/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.regex.Pattern;
import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.functions.CountUtils;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Countif
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        switch (args.length) {
            case 2: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        Eval criteriaArg = args[1];
        if (criteriaArg instanceof RefEval) {
            RefEval re = (RefEval)criteriaArg;
            criteriaArg = re.getInnerValueEval();
        }
        if (criteriaArg instanceof BlankEval) {
            return NumberEval.ZERO;
        }
        CountUtils.I_MatchPredicate mp = Countif.createCriteriaPredicate(criteriaArg);
        return this.countMatchingCellsInArea(args[0], mp);
    }

    private Eval countMatchingCellsInArea(Eval rangeArg, CountUtils.I_MatchPredicate criteriaPredicate) {
        int result;
        if (rangeArg instanceof RefEval) {
            result = CountUtils.countMatchingCell((RefEval)rangeArg, criteriaPredicate);
        } else if (rangeArg instanceof AreaEval) {
            result = CountUtils.countMatchingCellsInArea((AreaEval)rangeArg, criteriaPredicate);
        } else {
            throw new IllegalArgumentException("Bad range arg type (" + rangeArg.getClass().getName() + ")");
        }
        return new NumberEval(result);
    }

    static CountUtils.I_MatchPredicate createCriteriaPredicate(Eval evaluatedCriteriaArg) {
        if (evaluatedCriteriaArg instanceof NumberEval) {
            return new NumberMatcher(((NumberEval)evaluatedCriteriaArg).getNumberValue(), CmpOp.OP_NONE);
        }
        if (evaluatedCriteriaArg instanceof BoolEval) {
            return new BooleanMatcher(((BoolEval)evaluatedCriteriaArg).getBooleanValue(), CmpOp.OP_NONE);
        }
        if (evaluatedCriteriaArg instanceof StringEval) {
            return Countif.createGeneralMatchPredicate((StringEval)evaluatedCriteriaArg);
        }
        throw new RuntimeException("Unexpected type for criteria (" + evaluatedCriteriaArg.getClass().getName() + ")");
    }

    private static CountUtils.I_MatchPredicate createGeneralMatchPredicate(StringEval stringEval) {
        String value = stringEval.getStringValue();
        CmpOp operator = CmpOp.getOperator(value);
        Boolean booleanVal = Countif.parseBoolean(value = value.substring(operator.getLength()));
        if (booleanVal != null) {
            return new BooleanMatcher(booleanVal, operator);
        }
        Double doubleVal = OperandResolver.parseDouble(value);
        if (doubleVal != null) {
            return new NumberMatcher(doubleVal, operator);
        }
        return new StringMatcher(value, operator);
    }

    static Boolean parseBoolean(String strRep) {
        if (strRep.length() < 1) {
            return null;
        }
        switch (strRep.charAt(0)) {
            case 'T': 
            case 't': {
                if (!"TRUE".equalsIgnoreCase(strRep)) break;
                return Boolean.TRUE;
            }
            case 'F': 
            case 'f': {
                if (!"FALSE".equalsIgnoreCase(strRep)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static final class BooleanMatcher
    implements CountUtils.I_MatchPredicate {
        private final int _value;
        private final CmpOp _operator;

        public BooleanMatcher(boolean value, CmpOp operator) {
            this._value = BooleanMatcher.boolToInt(value);
            this._operator = operator;
        }

        private static int boolToInt(boolean value) {
            return value ? 1 : 0;
        }

        public boolean matches(Eval x) {
            if (x instanceof StringEval) {
                return false;
            }
            if (!(x instanceof BoolEval)) {
                return false;
            }
            BoolEval be = (BoolEval)x;
            int testValue = BooleanMatcher.boolToInt(be.getBooleanValue());
            return this._operator.evaluate(testValue - this._value);
        }
    }

    private static final class CmpOp {
        public static final int NONE = 0;
        public static final int EQ = 1;
        public static final int NE = 2;
        public static final int LE = 3;
        public static final int LT = 4;
        public static final int GT = 5;
        public static final int GE = 6;
        public static final CmpOp OP_NONE = CmpOp.op("", 0);
        public static final CmpOp OP_EQ = CmpOp.op("=", 1);
        public static final CmpOp OP_NE = CmpOp.op("<>", 2);
        public static final CmpOp OP_LE = CmpOp.op("<=", 3);
        public static final CmpOp OP_LT = CmpOp.op("<", 4);
        public static final CmpOp OP_GT = CmpOp.op(">", 5);
        public static final CmpOp OP_GE = CmpOp.op(">=", 6);
        private final String _representation;
        private final int _code;

        private static CmpOp op(String rep, int code) {
            return new CmpOp(rep, code);
        }

        private CmpOp(String representation, int code) {
            this._representation = representation;
            this._code = code;
        }

        public int getLength() {
            return this._representation.length();
        }

        public int getCode() {
            return this._code;
        }

        public static CmpOp getOperator(String value) {
            int len = value.length();
            if (len < 1) {
                return OP_NONE;
            }
            char firstChar = value.charAt(0);
            switch (firstChar) {
                case '=': {
                    return OP_EQ;
                }
                case '>': {
                    if (len > 1) {
                        switch (value.charAt(1)) {
                            case '=': {
                                return OP_GE;
                            }
                        }
                    }
                    return OP_GT;
                }
                case '<': {
                    if (len > 1) {
                        switch (value.charAt(1)) {
                            case '=': {
                                return OP_LE;
                            }
                            case '>': {
                                return OP_NE;
                            }
                        }
                    }
                    return OP_LT;
                }
            }
            return OP_NONE;
        }

        public boolean evaluate(boolean cmpResult) {
            switch (this._code) {
                case 0: 
                case 1: {
                    return cmpResult;
                }
                case 2: {
                    return !cmpResult;
                }
            }
            throw new RuntimeException("Cannot call boolean evaluate on non-equality operator '" + this._representation + "'");
        }

        public boolean evaluate(int cmpResult) {
            switch (this._code) {
                case 0: 
                case 1: {
                    return cmpResult == 0;
                }
                case 2: {
                    return cmpResult == 0;
                }
                case 4: {
                    return cmpResult < 0;
                }
                case 3: {
                    return cmpResult <= 0;
                }
                case 5: {
                    return cmpResult > 0;
                }
                case 6: {
                    return cmpResult <= 0;
                }
            }
            throw new RuntimeException("Cannot call boolean evaluate on non-equality operator '" + this._representation + "'");
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName());
            sb.append(" [").append(this._representation).append("]");
            return sb.toString();
        }
    }

    private static final class NumberMatcher
    implements CountUtils.I_MatchPredicate {
        private final double _value;
        private final CmpOp _operator;

        public NumberMatcher(double value, CmpOp operator) {
            this._value = value;
            this._operator = operator;
        }

        public boolean matches(Eval x) {
            double testValue;
            if (x instanceof StringEval) {
                StringEval se = (StringEval)x;
                Double val = OperandResolver.parseDouble(se.getStringValue());
                if (val == null) {
                    return false;
                }
                testValue = val;
            } else if (x instanceof NumberEval) {
                NumberEval ne = (NumberEval)x;
                testValue = ne.getNumberValue();
            } else {
                return false;
            }
            return this._operator.evaluate(Double.compare(testValue, this._value));
        }
    }

    private static final class StringMatcher
    implements CountUtils.I_MatchPredicate {
        private final String _value;
        private final CmpOp _operator;
        private final Pattern _pattern;

        public StringMatcher(String value, CmpOp operator) {
            this._value = value;
            this._operator = operator;
            switch (operator.getCode()) {
                case 0: 
                case 1: 
                case 2: {
                    this._pattern = StringMatcher.getWildCardPattern(value);
                    break;
                }
                default: {
                    this._pattern = null;
                }
            }
        }

        public boolean matches(Eval x) {
            if (x instanceof BlankEval) {
                switch (this._operator.getCode()) {
                    case 0: 
                    case 1: {
                        return this._value.length() == 0;
                    }
                }
                return false;
            }
            if (!(x instanceof StringEval)) {
                return false;
            }
            String testedValue = ((StringEval)x).getStringValue();
            if (testedValue.length() < 1 && this._value.length() < 1) {
                switch (this._operator.getCode()) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }
            if (this._pattern != null) {
                return this._operator.evaluate(this._pattern.matcher(testedValue).matches());
            }
            return this._operator.evaluate(testedValue.compareTo(this._value));
        }

        private static Pattern getWildCardPattern(String value) {
            int len = value.length();
            StringBuffer sb = new StringBuffer(len);
            boolean hasWildCard = false;
            int i = 0;
            while (i < len) {
                char ch = value.charAt(i);
                block0 : switch (ch) {
                    case '?': {
                        hasWildCard = true;
                        sb.append('.');
                        break;
                    }
                    case '*': {
                        hasWildCard = true;
                        sb.append(".*");
                        break;
                    }
                    case '~': {
                        if (i + 1 < len) {
                            ch = value.charAt(i + 1);
                            switch (ch) {
                                case '*': 
                                case '?': {
                                    hasWildCard = true;
                                    sb.append('[').append(ch).append(']');
                                    ++i;
                                    break block0;
                                }
                            }
                        }
                        sb.append('~');
                        break;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '[': 
                    case ']': 
                    case '^': {
                        sb.append("\\").append(ch);
                        break;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
                ++i;
            }
            if (hasWildCard) {
                return Pattern.compile(sb.toString());
            }
            return null;
        }
    }
}

