/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.hssf.util.CellRangeAddress;

public class Region {
    private int rowFrom;
    private short colFrom;
    private int rowTo;
    private short colTo;

    public Region() {
    }

    public Region(int rowFrom, short colFrom, int rowTo, short colTo) {
        this.rowFrom = rowFrom;
        this.rowTo = rowTo;
        this.colFrom = colFrom;
        this.colTo = colTo;
    }

    public short getColumnFrom() {
        return this.colFrom;
    }

    public int getRowFrom() {
        return this.rowFrom;
    }

    public short getColumnTo() {
        return this.colTo;
    }

    public int getRowTo() {
        return this.rowTo;
    }

    public void setColumnFrom(short colFrom) {
        this.colFrom = colFrom;
    }

    public void setRowFrom(int rowFrom) {
        this.rowFrom = rowFrom;
    }

    public void setColumnTo(short colTo) {
        this.colTo = colTo;
    }

    public void setRowTo(int rowTo) {
        this.rowTo = rowTo;
    }

    public static Region[] convertCellRangesToRegions(CellRangeAddress[] cellRanges) {
        int size = cellRanges.length;
        if (size < 1) {
            return new Region[0];
        }
        Region[] result = new Region[size];
        int i = 0;
        while (i != size) {
            result[i] = Region.convertToRegion(cellRanges[i]);
            ++i;
        }
        return result;
    }

    private static Region convertToRegion(CellRangeAddress cr) {
        return new Region(cr.getFirstRow(), (short)cr.getFirstColumn(), cr.getLastRow(), (short)cr.getLastColumn());
    }

    public static CellRangeAddress[] convertRegionsToCellRanges(Region[] regions) {
        int size = regions.length;
        if (size < 1) {
            return new CellRangeAddress[0];
        }
        CellRangeAddress[] result = new CellRangeAddress[size];
        int i = 0;
        while (i != size) {
            result[i] = Region.convertToCellRangeAddress(regions[i]);
            ++i;
        }
        return result;
    }

    public static CellRangeAddress convertToCellRangeAddress(Region r) {
        return new CellRangeAddress(r.getRowFrom(), r.getRowTo(), r.getColumnFrom(), r.getColumnTo());
    }
}

