/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;

public abstract class AbstractComponentNameMapper
implements IWritableComponentNameMapper {
    private IWritableComponentNameCache m_cache;
    private Object m_context;

    public AbstractComponentNameMapper(IWritableComponentNameCache componentNameCache, Object context) {
        this.setCompNameCache(componentNameCache);
        this.setContext(context);
    }

    public IWritableComponentNameCache getCompNameCache() {
        return this.m_cache;
    }

    public void setCompNameCache(IWritableComponentNameCache componentNameCache) {
        this.m_cache = componentNameCache;
    }

    public void setContext(Object context) {
        this.m_context = context;
    }

    protected Object getContext() {
        return this.m_context;
    }

    public void changeReuse(IComponentNameReuser user, String oldGuid, String newGuid) throws IncompatibleTypeException, PMException {
        if (user == null) {
            return;
        }
        if (newGuid != null) {
            CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
            List availableComponents = this.getFilterToolkitId() != null ? compSystem.getComponents(this.getFilterToolkitId(), true) : compSystem.getComponents();
            boolean isValidType = this.updateComponentType(newGuid, user.getComponentType(this.getCompNameCache(), availableComponents));
            if (!isValidType) {
                String currType = this.getCompNameCache().getCompNamePo(newGuid).getComponentType();
                String userType = user.getComponentType(this.getCompNameCache(), availableComponents);
                IComponentNamePO compNamePo = this.getCompNameCache().getCompNamePo(newGuid);
                StringBuilder msgBuid = new StringBuilder();
                msgBuid.append(Messages.ErrorSavingChangedComponentName);
                msgBuid.append(".");
                msgBuid.append("\n");
                msgBuid.append("'");
                msgBuid.append(currType);
                msgBuid.append("'");
                msgBuid.append(" ");
                msgBuid.append("-");
                msgBuid.append(">");
                msgBuid.append(" ");
                msgBuid.append("'");
                msgBuid.append(userType);
                msgBuid.append("'");
                msgBuid.append("!");
                String msg = msgBuid.toString();
                throw new IncompatibleTypeException(compNamePo, msg, MessageIDs.E_COMP_TYPE_INCOMPATIBLE, new String[]{compNamePo.getName(), CompSystemI18n.getString((String)currType), CompSystemI18n.getString((String)userType)});
            }
            this.getCompNameCache().addReuse(newGuid);
        }
        user.changeCompName(oldGuid, newGuid);
        if (oldGuid != null) {
            this.updateComponentType(oldGuid, null);
            this.getCompNameCache().removeReuse(oldGuid);
        }
    }

    private boolean updateComponentType(String guid, String typeOfReuse) {
        String newType;
        Set<String> usedTypes = this.getUsedTypes(guid);
        IComponentNamePO compNamePo = this.getCompNameCache().getCompNamePo(guid);
        if (typeOfReuse != null) {
            usedTypes.add(typeOfReuse);
        }
        if ((newType = ComponentNamesBP.getInstance().computeComponentType(compNamePo.getName(), usedTypes)) == null) {
            return false;
        }
        if (compNamePo.getParentProjectId() == null || compNamePo.getParentProjectId().equals(GeneralStorage.getInstance().getProject().getId())) {
            compNamePo.setComponentType(newType);
        }
        return !newType.equals("guidancer.abstract.Unknown") || typeOfReuse == null;
    }

    protected String getFilterToolkitId() {
        return null;
    }
}

