/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReentryProperty {
    public static final ReentryProperty CONTINUE = new ReentryProperty(1);
    public static final ReentryProperty REPEAT = new ReentryProperty(2);
    public static final ReentryProperty BREAK = new ReentryProperty(3);
    public static final ReentryProperty GOTO = new ReentryProperty(4);
    public static final ReentryProperty RETURN = new ReentryProperty(5);
    public static final ReentryProperty STOP = new ReentryProperty(6);
    public static final ReentryProperty EXIT = new ReentryProperty(7);
    public static final ReentryProperty RETRY = new ReentryProperty(8);
    public static final ReentryProperty[] REENTRY_PROP_ARRAY = new ReentryProperty[]{BREAK, CONTINUE, EXIT, RETURN, STOP, RETRY};
    public static final ReentryProperty[] TS_REENTRY_PROP_ARRAY = new ReentryProperty[]{CONTINUE, EXIT, STOP};
    private static final Logger LOG = LoggerFactory.getLogger(TestExecution.class);
    private int m_value = 0;

    private ReentryProperty(int value) {
        this.m_value = value;
    }

    private ReentryProperty() {
    }

    public static ReentryProperty getProperty(Integer reentryPropValue) throws InvalidDataException {
        int val = reentryPropValue == null ? 0 : reentryPropValue;
        ReentryProperty.validateValue(val);
        switch (val) {
            case 1: {
                return CONTINUE;
            }
            case 2: {
                return REPEAT;
            }
            case 3: {
                return BREAK;
            }
            case 4: {
                return GOTO;
            }
            case 5: {
                return RETURN;
            }
            case 6: {
                return STOP;
            }
            case 7: {
                return EXIT;
            }
            case 8: {
                return RETRY;
            }
        }
        return null;
    }

    public static Integer getProperty(String reentryPropValue) throws InvalidDataException {
        String val;
        String string = val = reentryPropValue == null ? "" : reentryPropValue;
        if (val.equals(Messages.EventExecTestCasePOCONTINUE)) {
            return 1;
        }
        if (val.equals(Messages.EventExecTestCasePOREPEAT)) {
            return 2;
        }
        if (val.equals(Messages.EventExecTestCasePOBREAK)) {
            return 3;
        }
        if (val.equals(Messages.EventExecTestCasePOGOTO)) {
            return 4;
        }
        if (val.equals(Messages.EventExecTestCasePORETURN)) {
            return 5;
        }
        if (val.equals(Messages.EventExecTestCasePOSTOP)) {
            return 6;
        }
        if (val.equals(Messages.EventExecTestCasePOEXIT)) {
            return 7;
        }
        if (val.equals(Messages.EventExecTestCasePORETRY)) {
            return 8;
        }
        LOG.error(String.valueOf(Messages.UnsupportedReentryProperty) + " " + val);
        throw new InvalidDataException(String.valueOf(Messages.UnsupportedReentryProperty) + " " + val, MessageIDs.E_UNSUPPORTED_REENTRY);
    }

    private static void validateValue(int value) throws InvalidDataException {
        int i = 0;
        while (i < REENTRY_PROP_ARRAY.length) {
            ReentryProperty prop = REENTRY_PROP_ARRAY[i];
            if (prop.getValue() == value) {
                return;
            }
            ++i;
        }
        LOG.error(String.valueOf(Messages.UnsupportedReentryProperty) + " " + value);
        throw new InvalidDataException(String.valueOf(Messages.UnsupportedReentryProperty) + " " + value, MessageIDs.E_UNSUPPORTED_REENTRY);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.m_value).toHashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ReentryProperty ? ((ReentryProperty)obj).getValue() == this.m_value : false;
    }

    public int getValue() {
        return this.m_value;
    }

    public String toString() {
        switch (this.m_value) {
            case 1: {
                return Messages.EventExecTestCasePOCONTINUE;
            }
            case 2: {
                return Messages.EventExecTestCasePOREPEAT;
            }
            case 3: {
                return Messages.EventExecTestCasePOBREAK;
            }
            case 4: {
                return Messages.EventExecTestCasePOGOTO;
            }
            case 5: {
                return Messages.EventExecTestCasePORETURN;
            }
            case 6: {
                return Messages.EventExecTestCasePOSTOP;
            }
            case 7: {
                return Messages.EventExecTestCasePOEXIT;
            }
            case 8: {
                return Messages.EventExecTestCasePORETRY;
            }
        }
        Assert.notReached((String)(String.valueOf(Messages.WrongTypeOfReentryProperty) + "!"));
        return "";
    }
}

