/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.model.AbstractTestResult;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.tools.objects.IMonitoringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResult
extends AbstractTestResult {
    private String m_projectName;
    private String m_projectGuid;
    private int m_projectMajorVersionNumber;
    private int m_projectMinorVersionNumber;
    private long m_projectId;
    private String m_monitoringId;
    private Map<String, IMonitoringValue> m_monitoringValues;
    private byte[] m_reportData;
    private boolean m_reportWritten;
    private String m_pathToReport;
    private Map<String, String> m_autConfigMap;

    public TestResult(TestResultNode rootResultNode, Map<String, String> autConfigMap) {
        super(rootResultNode);
        IProjectPO project = GeneralStorage.getInstance().getProject();
        this.m_projectName = project.getName();
        this.m_projectGuid = project.getGuid();
        this.m_projectMajorVersionNumber = project.getMajorProjectVersion();
        this.m_projectMinorVersionNumber = project.getMinorProjectVersion();
        this.m_projectId = project.getId();
        this.setAutConfigMap(autConfigMap);
    }

    @Override
    public String getAutAgentHostName() {
        return MapUtils.getString(this.getAutConfigMap(), (Object)"SERVER", (String)"");
    }

    @Override
    public String getAutArguments() {
        return MapUtils.getString(this.getAutConfigMap(), (Object)"AUT_ARGUMENTS", (String)"");
    }

    @Override
    public String getAutConfigName() {
        return MapUtils.getString(this.getAutConfigMap(), (Object)"CONFIG_NAME", (String)"autrun");
    }

    public String getAutId() {
        return MapUtils.getString(this.getAutConfigMap(), (Object)"AUT_ID", (String)"autrun");
    }

    @Override
    public Date getEndTime() {
        return ClientTestFactory.getClientTest().getEndTime();
    }

    @Override
    public int getExpectedNumberOfSteps() {
        return TestExecution.getInstance().getExpectedNumberOfSteps();
    }

    @Override
    public int getNumberOfEventHandlerSteps() {
        return TestExecution.getInstance().getNumberOfEventHandlerSteps() + TestExecution.getInstance().getNumberOfRetriedSteps();
    }

    @Override
    public int getNumberOfFailedSteps() {
        return TestExecution.getInstance().getNumberOfFailedSteps();
    }

    @Override
    public int getNumberOfTestedSteps() {
        return TestExecution.getInstance().getNumberOfTestedSteps();
    }

    @Override
    public String getProjectGuid() {
        return this.m_projectGuid;
    }

    @Override
    public long getProjectId() {
        return this.m_projectId;
    }

    @Override
    public int getProjectMajorVersion() {
        return this.m_projectMajorVersionNumber;
    }

    @Override
    public int getProjectMinorVersion() {
        return this.m_projectMinorVersionNumber;
    }

    @Override
    public String getProjectName() {
        return this.m_projectName;
    }

    @Override
    public Date getStartTime() {
        return ClientTestFactory.getClientTest().getTestsuiteStartTime();
    }

    @Override
    public String getTestLanguage() {
        Locale testLocale = TestExecution.getInstance().getLocale();
        return testLocale != null ? testLocale.getDisplayName() : "";
    }

    public String getMonitoringId() {
        return this.m_monitoringId;
    }

    public Map<String, IMonitoringValue> getMonitoringValues() {
        return this.m_monitoringValues;
    }

    public void setMonitoringValues(Map<String, IMonitoringValue> monitoringValues) {
        this.m_monitoringValues = monitoringValues;
    }

    public void setMonitoringId(String monitoringId) {
        this.m_monitoringId = monitoringId;
    }

    public byte[] getReportData() {
        return this.m_reportData;
    }

    public void setReportData(byte[] reportData) {
        this.m_reportData = reportData;
    }

    public boolean isReportWritten() {
        return this.m_reportWritten;
    }

    public void setReportWritten(boolean reportWritten) {
        this.m_reportWritten = reportWritten;
    }

    public String getPathToReport() {
        return this.m_pathToReport;
    }

    public void setPathToReport(String pathToReport) {
        this.m_pathToReport = pathToReport;
    }

    private void setAutConfigMap(Map<String, String> autConfigMap) {
        this.m_autConfigMap = autConfigMap;
    }

    public Map<String, String> getAutConfigMap() {
        return this.m_autConfigMap;
    }
}

