/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.SWT;

public class KeyCodeConverter {
    private static Map converterTable = null;

    static {
        converterTable = new HashMap();
        converterTable.put("none", new Integer(-1));
        converterTable.put("shift", new Integer(131072));
        converterTable.put("control", new Integer(262144));
        converterTable.put("alt", new Integer(65536));
        converterTable.put("meta", new Integer(0x400000));
        converterTable.put("cmd", new Integer(0x400000));
        converterTable.put("mod", new Integer(SWT.MOD1));
    }

    private KeyCodeConverter() {
    }

    public static int getKeyCode(String key) {
        if (key == null) {
            throw new RobotException("Key is null!", EventFactory.createConfigErrorEvent());
        }
        Integer keyCode = (Integer)converterTable.get(key.toLowerCase());
        if (keyCode == null) {
            throw new RobotException("No KeyCode found for key '" + key + "'", EventFactory.createConfigErrorEvent());
        }
        return keyCode;
    }
}

