/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.gen.parser.parameter.lexer.LexerException;
import org.eclipse.jubula.client.core.gen.parser.parameter.parser.Parser;
import org.eclipse.jubula.client.core.gen.parser.parameter.parser.ParserException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.parser.parameter.JubulaParameterLexer;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.ParsedParameter;
import org.eclipse.jubula.client.core.utils.SemanticParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiParamValueConverter
extends ParamValueConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GuiParamValueConverter.class);

    public GuiParamValueConverter(String guiString, IParameterInterfacePO currentNode, Locale locale, IParamDescriptionPO desc, IParamValueValidator validator) {
        super(currentNode, locale, desc, validator);
        this.init(guiString);
    }

    protected GuiParamValueConverter() {
    }

    protected void init(String guiString) {
        this.setGuiString(guiString);
        this.createTokens();
    }

    @Override
    void createTokens() {
        Parser parser = new Parser(new JubulaParameterLexer(new PushbackReader(new StringReader(StringUtils.defaultString((String)this.getGuiString())))));
        ParsedParameter parsedParam = new ParsedParameter(true, this.getCurrentNode(), this.getDesc());
        try {
            parser.parse().apply(parsedParam);
            this.setTokens(parsedParam.getTokens());
        }
        catch (LexerException e) {
            this.createErrors(e, this.getGuiString());
        }
        catch (ParserException e) {
            this.createErrors(e, this.getGuiString());
        }
        catch (IOException e) {
            LOG.error(Messages.ParameterParsingErrorOccurred, (Throwable)e);
            this.createErrors(e, this.getGuiString());
        }
        catch (SemanticParsingException e) {
            this.createErrors(e, this.getGuiString());
        }
    }

    @Override
    void validateSingleTokens() {
        for (IParamValueToken token : this.getTokens()) {
            ParamValueConverter.ConvValidationState state = token.validate();
            this.createTokenError(state, token);
        }
        if (!this.containsErrors()) {
            ParamValueConverter.ConvValidationState state = this.getValidator().validateInput(this.getTokens());
            for (IParamValueToken token : this.getTokens()) {
                Integer errorKey = token.getErrorKey();
                if (errorKey != null && state == ParamValueConverter.ConvValidationState.invalid) {
                    this.createTokenError(state, token);
                    return;
                }
                if (state != ParamValueConverter.ConvValidationState.undecided) continue;
                this.createTokenError(state, token);
            }
        }
    }

    public Set<String> getParametersToAdd(ISpecTestCasePO parent) {
        List<String> newRefs = this.getNamesForReferences();
        HashSet<String> refs = new HashSet<String>(newRefs);
        if (!refs.isEmpty()) {
            for (IParamDescriptionPO desc : parent.getParameterList()) {
                refs.remove(desc.getName());
            }
        }
        return refs;
    }

    @Override
    public String getModelString() {
        if (super.getModelString() == null) {
            StringBuilder builder = new StringBuilder();
            for (IParamValueToken token : this.getTokens()) {
                String modelString = token.getModelString();
                if (modelString == null) {
                    return null;
                }
                builder.append(token.getModelString());
            }
            this.setModelString(builder.toString());
        }
        return super.getModelString();
    }
}

