/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.gef.util;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jubula.rc.rcp.gef.factory.DefaultEditPartAdapterFactory;
import org.eclipse.jubula.rc.rcp.gef.identifier.IEditPartIdentifier;
import org.eclipse.swt.widgets.Display;

public class FigureCanvasUtil {
    private FigureCanvasUtil() {
    }

    public static GraphicalViewer getViewer(FigureCanvas figureCanvas) {
        FigureCanvas parent = figureCanvas;
        while (parent != null && !(parent.getData("TEST_GEF_VIEWER") instanceof GraphicalViewer)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return (GraphicalViewer)parent.getData("TEST_GEF_VIEWER");
        }
        return null;
    }

    public static EditPart findAtCurrentMousePosition(Display display, EditPartViewer viewer) {
        Point cursorLocation = new Point(display.map(null, viewer.getControl(), display.getCursorLocation()));
        EditPart editPart = viewer.findObjectAt(cursorLocation);
        EditPart primaryEditPart = FigureCanvasUtil.getPrimaryEditPart(editPart, viewer.getRootEditPart());
        return primaryEditPart;
    }

    public static EditPart getPrimaryEditPart(EditPart editPart, RootEditPart root) {
        EditPart currentEditPart = editPart;
        while (currentEditPart != root.getContents() && currentEditPart != null) {
            IEditPartIdentifier identifier = DefaultEditPartAdapterFactory.loadFigureIdentifier(currentEditPart);
            if (identifier != null) {
                return currentEditPart;
            }
            currentEditPart = currentEditPart.getParent();
        }
        return null;
    }
}

