/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jubula.client.analyze.definition.IAnalyze;
import org.eclipse.jubula.client.analyze.internal.Analyze;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.internal.AnalyzeRun;
import org.eclipse.jubula.client.analyze.ui.i18n.Messages;
import org.eclipse.jubula.client.analyze.ui.internal.QueryResult;
import org.eclipse.jubula.client.analyze.ui.internal.helper.ContextHelper;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractQuery;
import org.eclipse.search.ui.ISearchResult;

public class Query
extends AbstractQuery {
    private QueryResult m_queryResult;
    private AnalyzeRun m_analyzeRun;

    public Query(AnalyzeRun analyzeRun) {
        this.m_analyzeRun = analyzeRun;
    }

    protected void setQueryResult(QueryResult queryResult) {
        this.m_queryResult = queryResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            this.calculate(monitor);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    public void calculate(IProgressMonitor monitor) throws InterruptedException {
        Object node = ContextHelper.getSelection();
        QueryResult qr = new QueryResult(this);
        int workAmount = this.getAnalyzeRun().getAnalyzeRunList().size();
        monitor.beginTask(Messages.RunningAnalyzes, workAmount);
        ArrayList anaList = new ArrayList(this.getAnalyzeRun().getAnalyzeRunList());
        int i = 0;
        while (i < anaList.size()) {
            Analyze analyze = (Analyze)anaList.get(i);
            IAnalyze executableExtension = (IAnalyze)analyze.getExecutableExtension();
            monitor.subTask(String.valueOf(Messages.Running) + analyze.getName());
            AnalyzeResult res = executableExtension.execute(node, (IProgressMonitor)new SubProgressMonitor(monitor, 1), analyze.getResultType(), analyze.getAnalyzeParameter(), analyze.getName(), analyze.getExecutionEvent());
            qr.getResultMap().put(analyze, res);
            ++i;
        }
        this.setQueryResult(qr);
        monitor.done();
    }

    public String getLabel() {
        if (this.getAnalyzeRun().getAnalyzeRunList().size() == 1) {
            return String.valueOf(this.getTimestamp()) + ": " + ((Analyze)this.getAnalyzeRun().getAnalyzeRunList().get(0)).getName();
        }
        return "";
    }

    public boolean canRunInBackground() {
        return false;
    }

    public ISearchResult getSearchResult() {
        return this.m_queryResult;
    }

    public AnalyzeRun getAnalyzeRun() {
        return this.m_analyzeRun;
    }
}

