/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.events.InteractionEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.teststyle.i18n.Messages;
import org.eclipse.jubula.client.teststyle.quickfix.Quickfix;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class QuickfixFactory {
    private QuickfixFactory() {
    }

    public static Quickfix[] getDefaultQuickfixFor(Object obj) {
        if (obj instanceof ISpecTestCasePO) {
            return new Quickfix[]{new QuickfixOpenTestCase()};
        }
        if (obj instanceof ITestSuitePO) {
            return new Quickfix[]{new QuickfixOpenTestSuite()};
        }
        if (obj instanceof Long) {
            return new Quickfix[]{new QuickfixOpenTestDataCubeEditor()};
        }
        if (obj instanceof ICategoryPO) {
            return new Quickfix[]{new QuickfixSelectCategory()};
        }
        if (obj instanceof ITestJobPO) {
            return new Quickfix[]{new QuickfixOpenTestJob()};
        }
        if (obj instanceof IExecTestCasePO) {
            return new Quickfix[]{new QuickfixOpenTestCase()};
        }
        return new Quickfix[0];
    }

    public static class QuickfixOpenTestCase
    extends Quickfix {
        public String getLabel() {
            return Messages.QuickfixOpenTestCase;
        }

        public void run(IMarker marker) {
            Object obj = this.getObject(marker);
            if (obj instanceof IExecTestCasePO) {
                IExecTestCasePO execTestCase = (IExecTestCasePO)obj;
                AbstractOpenHandler.openEditor((IPersistentObject)execTestCase.getParentNode());
            } else {
                AbstractOpenHandler.openEditor((IPersistentObject)((IPersistentObject)obj));
            }
        }
    }

    public static class QuickfixOpenTestDataCubeEditor
    extends Quickfix {
        public String getLabel() {
            return Messages.QuickfixOpenCTDEditor;
        }

        public void run(IMarker marker) {
            IEditorPart editor;
            ITestDataCategoryPO centralTestData;
            IProjectPO project = GeneralStorage.getInstance().getProject();
            if (project != null && (centralTestData = project.getTestDataCubeCont()) != null && (editor = AbstractOpenHandler.openEditor((IPersistentObject)centralTestData)) != null) {
                editor.getSite().getPage().activate((IWorkbenchPart)editor);
            }
        }
    }

    public static class QuickfixOpenTestJob
    extends Quickfix {
        public String getLabel() {
            return Messages.QuickfixOpenTestJob;
        }

        public void run(IMarker marker) {
            AbstractOpenHandler.openEditor((IPersistentObject)((IPersistentObject)this.getObject(marker)));
        }
    }

    public static class QuickfixOpenTestSuite
    extends Quickfix {
        public String getLabel() {
            return Messages.QuickfixOpenTestSuite;
        }

        public void run(IMarker marker) {
            AbstractOpenHandler.openEditor((IPersistentObject)((IPersistentObject)this.getObject(marker)));
        }
    }

    public static class QuickfixSelectCategory
    extends Quickfix {
        public String getLabel() {
            return Messages.QuickfixSelectCategory;
        }

        public void run(IMarker marker) {
            INodePO node = (INodePO)this.getObject(marker);
            if (node != null) {
                if (!Utils.openPerspective((String)"org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective")) {
                    return;
                }
                if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals("org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective")) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NO_PERSPECTIVE_CHANGE);
                    return;
                }
                TestCaseBrowser view = MultipleTCBTracker.getInstance().getMainTCB();
                ITreeViewerContainer specView = (ITreeViewerContainer)view;
                InteractionEventDispatcher.getDefault().fireProgammableSelectionEvent((IStructuredSelection)new StructuredSelection((Object)node));
                if (specView != null) {
                    specView.getTreeViewer().refresh();
                    specView.getTreeViewer().reveal((Object)node);
                    specView.getTreeViewer().getTree().update();
                    view.setFocus();
                    specView.getTreeViewer().expandToLevel((Object)node, 0);
                    specView.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node), true);
                }
            }
        }
    }
}

