/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.utils.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.tools.exception.GDConfigXmlException;
import org.eclipse.jubula.tools.utils.generator.AbstractComponentBuilder;
import org.eclipse.jubula.tools.utils.generator.ActionInfo;
import org.eclipse.jubula.tools.utils.generator.ComponentInfo;
import org.eclipse.jubula.tools.utils.generator.IProcessor;
import org.eclipse.jubula.tools.utils.generator.ToolkitConfig;
import org.eclipse.jubula.tools.utils.generator.ToolkitInfo;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.InvalidAction;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;

public class CompSystemProcessor
implements IProcessor {
    private CompSystem m_compSystem;

    public CompSystemProcessor(ToolkitConfig config) throws GDConfigXmlException {
        AbstractComponentBuilder builder = new AbstractComponentBuilder(config);
        this.m_compSystem = builder.getCompSystem();
    }

    public CompSystemProcessor(CompSystem compSystem) {
        this.m_compSystem = compSystem;
    }

    public List getToolkitInfos() {
        ArrayList<ToolkitInfo> infos = new ArrayList<ToolkitInfo>();
        List descriptors = this.m_compSystem.getAllToolkitPluginDescriptors();
        Iterator i = descriptors.iterator();
        while (i.hasNext()) {
            ToolkitPluginDescriptor descr = (ToolkitPluginDescriptor)i.next();
            ToolkitInfo info = CompSystemProcessor.getToolkitInfo(descr);
            infos.add(info);
        }
        return infos;
    }

    public static ToolkitInfo getToolkitInfo(ToolkitPluginDescriptor descr) {
        ToolkitInfo info = new ToolkitInfo(descr.getName(), descr.getToolkitID());
        return info;
    }

    public List getCompInfos() {
        ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>();
        Iterator it = this.m_compSystem.getComponents().iterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            if (!component.isVisible()) continue;
            ToolkitInfo tkInfo = CompSystemProcessor.getToolkitInfo(component.getToolkitDesriptor());
            infos.add(new ComponentInfo(component, tkInfo));
        }
        return infos;
    }

    public List getCompInfos(String toolkitId, String toolkitName) {
        ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>();
        ToolkitInfo tkInfo = new ToolkitInfo(toolkitName, toolkitId);
        Iterator it = this.m_compSystem.getComponents(toolkitId, false).iterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            if (!component.isVisible()) continue;
            infos.add(new ComponentInfo(component, tkInfo));
        }
        return infos;
    }

    private void getHierarchyCompInfosImpl(List types, ComponentInfo componentInfo, int level) {
        Component component = componentInfo.getComponent();
        int newLevel = level;
        if (component.isVisible()) {
            types.add(componentInfo);
            ++newLevel;
        }
        Iterator it = component.getRealized().iterator();
        while (it.hasNext()) {
            Component realized = (Component)it.next();
            ToolkitInfo tkRealized = CompSystemProcessor.getToolkitInfo(realized.getToolkitDesriptor());
            ComponentInfo realizedInfo = new ComponentInfo(realized, newLevel, tkRealized);
            this.getHierarchyCompInfosImpl(types, realizedInfo, newLevel);
        }
    }

    public List getHierarchyCompInfos(ComponentInfo componentInfo) {
        ArrayList types = new ArrayList();
        this.getHierarchyCompInfosImpl(types, componentInfo, 0);
        return types;
    }

    public ComponentInfo getDefiningComp(ComponentInfo componentInfo, Action action) {
        ComponentInfo result = null;
        List types = this.getHierarchyCompInfos(componentInfo);
        int i = 0;
        while (i < types.size()) {
            try {
                ComponentInfo info = (ComponentInfo)types.get(i);
                if (!(info.getComponent().findAction(action.getName()) instanceof InvalidAction)) {
                    result = info;
                }
            }
            catch (GDConfigXmlException gDConfigXmlException) {}
            ++i;
        }
        return result;
    }

    public List getUsingComps(ComponentInfo compInfo) {
        Component comp = compInfo.getComponent();
        Set realizerSet = comp.getRealizers();
        realizerSet.remove(comp);
        ArrayList<ComponentInfo> realizerList = new ArrayList<ComponentInfo>();
        Iterator i = realizerSet.iterator();
        while (i.hasNext()) {
            Component compNext = (Component)i.next();
            if (!compNext.isVisible()) continue;
            ToolkitInfo tkNext = CompSystemProcessor.getToolkitInfo(compNext.getToolkitDesriptor());
            realizerList.add(new ComponentInfo(compNext, tkNext));
        }
        return realizerList;
    }

    public List getActions(ComponentInfo componentInfo, boolean newActions) {
        return this.getActions(componentInfo, newActions, false);
    }

    public List getActions(ComponentInfo componentInfo, boolean newActions, boolean deprecated) {
        ArrayList<ActionInfo> actions = new ArrayList<ActionInfo>();
        Iterator it = componentInfo.getComponent().getActions().iterator();
        while (it.hasNext()) {
            boolean inherited;
            Action action = (Action)it.next();
            if ((!deprecated || !action.isDeprecated()) && (deprecated || action.isDeprecated())) continue;
            ComponentInfo defining = this.getDefiningComp(componentInfo, action);
            boolean bl = inherited = defining.getComponent() != componentInfo.getComponent();
            if ((!newActions || inherited) && (newActions || !inherited)) continue;
            actions.add(new ActionInfo(action, defining));
        }
        return actions;
    }

    public List getDeprecatedActions() {
        ArrayList<ActionInfo> deprecated = new ArrayList<ActionInfo>();
        Iterator i = this.m_compSystem.getComponents().iterator();
        while (i.hasNext()) {
            Component comp = (Component)i.next();
            ComponentInfo ci = new ComponentInfo(comp, CompSystemProcessor.getToolkitInfo(comp.getToolkitDesriptor()));
            List actions = this.getActions(ci, true, true);
            Iterator j = actions.iterator();
            while (j.hasNext()) {
                ActionInfo ai = (ActionInfo)j.next();
                deprecated.add(ai);
            }
        }
        return deprecated;
    }
}

