/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.agent.AutAgent;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.StopAUTServerMessage;
import org.eclipse.jubula.communication.message.StopAUTServerStateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopAUTServerCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(StopAUTServerCommand.class);
    private StopAUTServerMessage m_message;

    public StopAUTServerMessage getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        try {
            this.m_message = (StopAUTServerMessage)message;
        }
        catch (ClassCastException cce) {
            if (log.isErrorEnabled()) {
                log.error("Cannot convert from " + message.getClass().toString() + " to " + this.m_message.getClass().toString(), (Throwable)cce);
            }
            throw cce;
        }
    }

    public Message execute() {
        log.debug("execute() called");
        AutAgent agent = AutStarter.getInstance().getAgent();
        if (agent != null) {
            agent.stopAut(this.m_message.getAutId(), true);
            return new StopAUTServerStateMessage();
        }
        return null;
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + "timeout() called when it shouldn't (no response)");
    }
}

