/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BundleUtils.class);

    private BundleUtils() {
    }

    public static URL getFileURL(Bundle bundle, String resouceName) {
        try {
            URL url = bundle.getEntry(resouceName);
            if (url != null) {
                return FileLocator.toFileURL((URL)url);
            }
            LOG.error(String.valueOf(Messages.Resource) + ":" + " " + resouceName + " " + Messages.NotFound + ".");
        }
        catch (MalformedURLException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static Properties loadProperties(Bundle bundle, String propertyFileName) throws JBFatalException {
        Properties prop = new Properties();
        InputStream propStream = null;
        try {
            try {
                propStream = BundleUtils.getFileURL(bundle, propertyFileName).openStream();
                prop.load(propStream);
            }
            catch (IOException e) {
                String msg = String.valueOf(Messages.CantLoad) + ":" + " " + propertyFileName;
                LOG.error(msg, (Throwable)e);
                throw new JBFatalException(msg, MessageIDs.E_PROPERTIES_FILE_NOT_FOUND);
            }
        }
        catch (Throwable throwable) {
            try {
                if (propStream != null) {
                    propStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (propStream != null) {
                propStream.close();
            }
        }
        catch (IOException iOException) {}
        return prop;
    }
}

