/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlledCache<TKey, TValue>
implements DataEventDispatcher.IDataChangedListener,
DataEventDispatcher.IProjectLoadedListener {
    private Map<TKey, TValue> m_cache;

    public ControlledCache(ControlTypes ... controlledBy) {
        this(17, controlledBy);
    }

    public ControlledCache(int size, ControlTypes ... controlledByList) {
        this.m_cache = new HashMap<TKey, TValue>(size);
        ControlTypes[] controlTypesArray = controlledByList;
        int n = controlledByList.length;
        int n2 = 0;
        while (n2 < n) {
            ControlTypes controlledBy = controlTypesArray[n2];
            this.registerHandler(controlledBy);
            ++n2;
        }
    }

    public TValue add(TKey key, TValue value) {
        return this.m_cache.put(key, value);
    }

    public TValue get(TKey key) {
        return this.m_cache.get(key);
    }

    public TValue remove(TKey key) {
        return this.m_cache.remove(key);
    }

    private void registerHandler(ControlTypes controlledBy) {
        if (controlledBy == ControlTypes.PROJECT_LOADED) {
            DataEventDispatcher.getInstance().addProjectLoadedListener(this, true);
        }
        if (controlledBy == ControlTypes.DATA_CHANGED) {
            DataEventDispatcher.getInstance().addDataChangedListener(this, true);
        }
    }

    @Override
    public void handleProjectLoaded() {
        this.m_cache.clear();
    }

    @Override
    public void handleDataChanged(DataChangedEvent ... events) {
        this.m_cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlTypes {
        PROJECT_LOADED,
        DATA_CHANGED;

    }
}

