/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses.tree;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractStringNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.util.MatchUtil;

public class StringNodePath
extends AbstractStringNodePath {
    public StringNodePath(String[] path, String operator) {
        super(path, operator);
    }

    public int getLength() {
        return this.getTreePath().length;
    }

    public Object getObject(int level) {
        return this.getTreePath()[level];
    }

    public boolean isInPath(Object node, int level, AbstractTreeOperationContext context) {
        Collection nodeTextList = context.getNodeTextList(node);
        String pattern = this.getTreePath()[level];
        Iterator it = nodeTextList.iterator();
        while (it.hasNext()) {
            String text = (String)it.next();
            if (!MatchUtil.getInstance().match(text, pattern, this.getOperator())) continue;
            return true;
        }
        return false;
    }

    public INodePath subPath(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex > this.getLength() || startIndex > endIndex) {
            throw new IndexOutOfBoundsException("Invalid index");
        }
        String[] newTreePath = new String[endIndex - startIndex];
        int i = startIndex;
        while (i < endIndex) {
            newTreePath[i] = this.getTreePath()[startIndex + i];
            ++i;
        }
        return new StringNodePath(newTreePath, this.getOperator());
    }
}

