/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.util.List;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.swt.driver.DefaultSwtEventMatcher;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class WindowSwtEventMatcher
implements IEventMatcher {
    private DefaultSwtEventMatcher m_eventMatcher;
    private final String m_title;
    private final String m_operator;
    private final boolean m_valForDisposed;

    public WindowSwtEventMatcher(String title, String operator, int eventCode, boolean valForDisposed) {
        this.m_title = title;
        this.m_operator = operator;
        this.m_eventMatcher = new DefaultSwtEventMatcher(eventCode);
        this.m_valForDisposed = valForDisposed;
    }

    public int getEventId() {
        return this.m_eventMatcher.getEventId();
    }

    public boolean isFallBackEventMatching(List eventObjects, Object graphicsComponent) {
        return false;
    }

    public boolean isMatching(Object eventObject) {
        if (this.m_eventMatcher.isMatching(eventObject)) {
            final Event event = (Event)eventObject;
            EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
            Boolean matched = (Boolean)evThreadQueuer.invokeAndWait("matchWindow", new IRunnable(){

                public Object run() {
                    if (event.widget instanceof Shell) {
                        Shell frame = (Shell)event.widget;
                        if (frame.isDisposed()) {
                            return WindowSwtEventMatcher.this.m_valForDisposed;
                        }
                        return MatchUtil.getInstance().match(frame.getText(), WindowSwtEventMatcher.this.m_title, WindowSwtEventMatcher.this.m_operator);
                    }
                    return Boolean.FALSE;
                }
            });
            return matched;
        }
        return false;
    }
}

