/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.ui.bridge;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.alm.mylyn.ui.bridge.listener.TaskActivationListener;
import org.eclipse.jubula.client.alm.mylyn.ui.bridge.monitor.EditorInteractionMonitor;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.events.InteractionEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.jubula.client.alm.mylyn.ui.bridge";
    private static Activator instance;
    private TaskActivationListener m_taskAktivationListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
    }

    void lazyStart() {
        EditorInteractionMonitor interestEditorTracker = new EditorInteractionMonitor();
        interestEditorTracker.install(PlatformUI.getWorkbench());
        InteractionEventDispatcher.getDefault().addIProgrammableSelectionListener((InteractionEventDispatcher.IProgrammableSelectionListener)new ModifyInterest());
        this.m_taskAktivationListener = new TaskActivationListener();
        TasksUi.getTaskActivityManager().addActivationListener((ITaskActivationListener)this.m_taskAktivationListener);
        DataEventDispatcher.getInstance().addProjectStateListener((DataEventDispatcher.IProjectStateListener)this.m_taskAktivationListener);
    }

    public static Activator getDefault() {
        return instance;
    }

    public void stop(BundleContext context) throws Exception {
        DataEventDispatcher.getInstance().removeProjectStateListener((DataEventDispatcher.IProjectStateListener)this.m_taskAktivationListener);
        super.stop(context);
    }

    public class ModifyInterest
    implements InteractionEventDispatcher.IProgrammableSelectionListener {
        public void processSelection(IStructuredSelection s) {
            for (Object interactionObject : s.toList()) {
                String originID = null;
                if (interactionObject instanceof INodePO) {
                    originID = ((INodePO)interactionObject).getGuid();
                } else if (interactionObject instanceof IReusedProjectPO) {
                    originID = ((IReusedProjectPO)interactionObject).getProjectGuid();
                }
                if (originID == null) continue;
                AbstractContextStructureBridge bridge = ContextCore.getStructureBridge(interactionObject);
                InteractionEvent selectionEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), bridge.getHandleIdentifier(interactionObject), originID);
                ContextCore.getContextManager().processInteractionEvent(selectionEvent);
            }
        }
    }

    public static class UiBridgeStartup
    extends ResourcesUiBridgePlugin.ResourcesUiBridgeStartup {
        public void lazyStartup() {
            Activator.getDefault().lazyStart();
            super.lazyStartup();
        }
    }
}

