/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.ui.bridge.bridge;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "org.eclipse.jubula.client.alm.mylyn.ui.bridge.content.type.node";
    private static Logger log = LoggerFactory.getLogger(NodeStructureBridge.class);

    public boolean acceptsObject(Object object) {
        Boolean accepted = false;
        if (object instanceof BasicSearchResult.SearchResultElement) {
            accepted = true;
        } else if (object instanceof INodePO) {
            accepted = true;
            INodePO node = this.getRoot((INodePO)object);
            String name = node.getName();
            if (name == null && log.isWarnEnabled()) {
                log.warn("found INodePO with no name");
                accepted = false;
            }
        } else if (object instanceof ISpecObjContPO || object instanceof IExecObjContPO || object instanceof IReusedProjectPO) {
            accepted = true;
        }
        return accepted;
    }

    private INodePO getRoot(INodePO node) {
        if (node.getParentNode() != null) {
            return this.getRoot(node.getParentNode());
        }
        return node;
    }

    public boolean canBeLandmark(String handle) {
        Object element = this.getObjectForHandle(handle);
        return this.canFilter(element);
    }

    public boolean canFilter(Object element) {
        Boolean filterable = true;
        if (element instanceof ISpecObjContPO || element instanceof IExecObjContPO) {
            filterable = false;
        }
        return filterable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getChildHandles(String handle) {
        ArrayList<String> childHandles = new ArrayList<String>();
        Object objForHandle = this.getObjectForHandle(handle);
        if (objForHandle instanceof INodePO) {
            INodePO node = (INodePO)objForHandle;
            for (INodePO child : node.getUnmodifiableNodeList()) {
                childHandles.add(this.getHandleIdentifier(child));
            }
            return childHandles;
        } else if (objForHandle instanceof IExecObjContPO) {
            for (IExecPersistable execs : ((IExecObjContPO)objForHandle).getExecObjList()) {
                childHandles.add(execs.getGuid());
            }
            return childHandles;
        } else if (objForHandle instanceof ISpecObjContPO) {
            for (ISpecPersistable specs : ((ISpecObjContPO)objForHandle).getSpecObjList()) {
                childHandles.add(specs.getGuid());
            }
            return childHandles;
        } else {
            if (!(objForHandle instanceof IReusedProjectPO)) return childHandles;
            try {
                IProjectPO reusedProject = ProjectPM.loadReusedProjectInMasterSession((IReusedProjectPO)((IReusedProjectPO)objForHandle));
                if (reusedProject == null) return childHandles;
                for (ISpecPersistable specs : reusedProject.getSpecObjCont().getSpecObjList()) {
                    childHandles.add(specs.getGuid());
                }
                return childHandles;
            }
            catch (JBException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
            }
        }
        return childHandles;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public String getHandleForOffsetInObject(Object resource, int offset) {
        return null;
    }

    public String getHandleIdentifier(Object object) {
        if (object instanceof INodePO) {
            return ((INodePO)object).getGuid();
        }
        if (object instanceof IReusedProjectPO) {
            return ((IReusedProjectPO)object).getProjectGuid();
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof INodePO) {
            return ((INodePO)object).getName();
        }
        if (object instanceof IReusedProjectPO) {
            return ((IReusedProjectPO)object).getName();
        }
        return "";
    }

    public Object getObjectForHandle(String handle) {
        IProjectPO activeProject;
        INodePO obj = null;
        if (handle != null && (activeProject = GeneralStorage.getInstance().getProject()) != null) {
            if (activeProject.getGuid().equals(handle)) {
                return activeProject;
            }
            obj = NodePM.getNode((Long)activeProject.getId(), (String)handle);
            if (obj == null) {
                for (IReusedProjectPO rProj : activeProject.getUsedProjects()) {
                    if (rProj.getProjectGuid().equals(handle)) {
                        obj = rProj;
                        break;
                    }
                    try {
                        Long rProjId = ProjectPM.findProjectId((String)rProj.getProjectGuid(), (Integer)rProj.getMajorNumber(), (Integer)rProj.getMinorNumber());
                        if (rProjId == null || (obj = NodePM.getNode((Long)rProjId, (String)handle)) == null) continue;
                        break;
                    }
                    catch (JBException jBException) {}
                }
            }
        }
        return obj;
    }

    public String getParentHandle(String handle) {
        try {
            INodePO node;
            Object objForHandle = this.getObjectForHandle(handle);
            if (objForHandle instanceof INodePO && (node = (INodePO)objForHandle).getParentNode() != null) {
                INodePO parent = node.getParentNode();
                if (parent == ISpecObjContPO.TCB_ROOT_NODE) {
                    IProjectPO activeProject = GeneralStorage.getInstance().getProject();
                    Long parentProjectId = node.getParentProjectId();
                    if (activeProject != null && parentProjectId != activeProject.getId()) {
                        return ProjectPM.getGuidOfProjectId((Long)parentProjectId);
                    }
                }
                return this.getHandleIdentifier(parent);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while retrieving parent handle.", (Throwable)e);
        }
        return null;
    }

    public boolean isDocument(String handle) {
        return true;
    }

    public String getParentContentType() {
        return CONTENT_TYPE;
    }
}

