/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.utils.AutAgentManager;

public final class ConnectAutAgentBP {
    private static ConnectAutAgentBP instance = null;
    private AutAgentManager.AutAgent m_currentAutAgent = null;
    private Set<AutAgentManager.AutAgent> m_autAgentFromPref = AutAgentManager.getInstance().getAutAgents();
    private IPropertyChangeListener m_autAgentPrefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (ConnectAutAgentBP.this.m_currentAutAgent != null && !AutAgentManager.getInstance().getAutAgents().contains(ConnectAutAgentBP.this.m_currentAutAgent)) {
                ConnectAutAgentBP.this.m_currentAutAgent = null;
            }
        }
    };

    private ConnectAutAgentBP() {
        Plugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.m_autAgentPrefListener);
    }

    public static ConnectAutAgentBP getInstance() {
        if (instance == null) {
            instance = new ConnectAutAgentBP();
        }
        return instance;
    }

    public void setCurrentAutAgent(AutAgentManager.AutAgent server) {
        this.m_currentAutAgent = server;
        AutAgentManager.getInstance().setLastUsedAutAgent(server);
        AutAgentManager.getInstance().storeAutAgentList();
    }

    public AutAgentManager.AutAgent getCurrentAutAgent() {
        return this.m_currentAutAgent;
    }

    public AutAgentManager.AutAgent getWorkingAutAgent() {
        AutAgentManager.AutAgent currentautAgent = null;
        AutAgentManager autAgentManager = AutAgentManager.getInstance();
        AutAgentManager.AutAgent lastUsedAutAgent = autAgentManager.getLastUsedAutAgent();
        if (this.m_currentAutAgent != null) {
            currentautAgent = this.m_currentAutAgent;
        } else if (lastUsedAutAgent != null) {
            currentautAgent = lastUsedAutAgent;
        } else if (autAgentManager.getAutAgents().size() == 1) {
            currentautAgent = (AutAgentManager.AutAgent)autAgentManager.getAutAgents().iterator().next();
        }
        return currentautAgent;
    }

    public List<IAUTConfigPO> computeUnconfiguredAutAgents() {
        ArrayList<IAUTConfigPO> unconfAutAgents = new ArrayList<IAUTConfigPO>();
        HashSet<IAUTConfigPO> confs = new HashSet<IAUTConfigPO>();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            Set auts = project.getAutMainList();
            for (IAUTMainPO aut : auts) {
                if (aut.getAutConfigSet().isEmpty()) continue;
                Iterator it = aut.getAutConfigSet().iterator();
                while (it.hasNext()) {
                    confs.add((IAUTConfigPO)it.next());
                }
            }
            for (IAUTConfigPO conf : confs) {
                if (!this.isUnconfiguredAutAgent(conf.getServer())) continue;
                unconfAutAgents.add(conf);
            }
        }
        return unconfAutAgents;
    }

    private boolean isUnconfiguredAutAgent(String autAgentName) {
        for (AutAgentManager.AutAgent server : this.m_autAgentFromPref) {
            if (!server.getName().equals(autAgentName)) continue;
            return false;
        }
        return true;
    }
}

