/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.JBPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.PropertyControllerLabelProvider;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class OMTechNameGUIPropertySource
extends AbstractPropertySource<IObjectMappingAssoziationPO> {
    public static final String P_ELEMENT_DISPLAY_COMP = Messages.OMTechNameGUIPropertySourceComponent;
    public static final String P_ELEMENT_DISPLAY_COMPADDINFO = Messages.OMTechNameGUIPropertySourceComponentAddInfo;
    public static final String P_ELEMENT_DISPLAY_COMPNAME = Messages.OMTechNameGUIPropertySourceComponentName;
    public static final String P_ELEMENT_DISPLAY_COMPCLASS = Messages.OMTechNameGUIPropertySourceCompClass;
    public static final String P_ELEMENT_DISPLAY_COMPSUPPCLASS = Messages.OMTechNameGUIPropertySourceCompSuppClass;
    public static final String P_ELEMENT_DISPLAY_HIERARCHY = Messages.OMTechNameGUIPropertySourceHierarchy;
    public static final String P_ELEMENT_DISPLAY_CONTEXT = Messages.OMTechNameGUIPropertySourceContext;
    public static final String P_ELEMENT_DISPLAY_PROPERTY_INFORMATION = Messages.OMTechNameGUIPropertySourcePropertyInformation;

    public OMTechNameGUIPropertySource(IObjectMappingAssoziationPO assoc) {
        super(assoc);
        this.initPropDescriptor();
    }

    protected void initPropDescriptor() {
        this.clearPropertyDescriptors();
        JBPropertyDescriptor propDes = null;
        propDes = new JBPropertyDescriptor(new ComponentNameController(), P_ELEMENT_DISPLAY_COMPNAME);
        propDes.setCategory(P_ELEMENT_DISPLAY_COMP);
        propDes.setLabelProvider((ILabelProvider)new PropertyControllerLabelProvider());
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ComponentClassController(), P_ELEMENT_DISPLAY_COMPCLASS);
        propDes.setCategory(P_ELEMENT_DISPLAY_COMP);
        propDes.setLabelProvider((ILabelProvider)new PropertyControllerLabelProvider());
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ComponentSuppClassController(), P_ELEMENT_DISPLAY_COMPSUPPCLASS);
        propDes.setCategory(P_ELEMENT_DISPLAY_COMPADDINFO);
        propDes.setLabelProvider((ILabelProvider)new PropertyControllerLabelProvider());
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        this.initHierarchy();
        this.initContext();
        this.initComponentProperties();
    }

    private void initComponentProperties() {
        Map componentProperties;
        IComponentIdentifier compId = ((IObjectMappingAssoziationPO)this.getGuiNode()).getCompIdentifier();
        if (compId != null && (componentProperties = compId.getComponentPropertiesMap()) != null) {
            int i = 0;
            for (Object o : componentProperties.keySet()) {
                if (!(o instanceof String)) continue;
                String key = (String)o;
                JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ComponentPropertiesController(i), key);
                propDes.setCategory(P_ELEMENT_DISPLAY_PROPERTY_INFORMATION);
                this.addPropertyDescriptor((IPropertyDescriptor)propDes);
                ++i;
            }
        }
    }

    private void initHierarchy() {
        JBPropertyDescriptor propDes = null;
        ICompIdentifierPO compId = ((IObjectMappingAssoziationPO)this.getGuiNode()).getTechnicalName();
        if (compId != null) {
            List hierarchy = compId.getHierarchyNames();
            int i = 0;
            while (i < hierarchy.size()) {
                propDes = i == 0 ? new JBPropertyDescriptor(new ComponentHierarchyController(i), P_ELEMENT_DISPLAY_HIERARCHY) : new JBPropertyDescriptor(new ComponentHierarchyController(i), "");
                propDes.setCategory(P_ELEMENT_DISPLAY_COMPADDINFO);
                this.addPropertyDescriptor((IPropertyDescriptor)propDes);
                ++i;
            }
        }
    }

    private void initContext() {
        JBPropertyDescriptor propDes = null;
        ICompIdentifierPO compId = ((IObjectMappingAssoziationPO)this.getGuiNode()).getTechnicalName();
        if (compId != null) {
            List context = compId.getNeighbours();
            int i = 0;
            while (i < context.size()) {
                propDes = i == 0 ? new JBPropertyDescriptor(new ComponentContextController(i), P_ELEMENT_DISPLAY_CONTEXT) : new JBPropertyDescriptor(new ComponentContextController(i), "");
                propDes.setCategory(P_ELEMENT_DISPLAY_COMPADDINFO);
                this.addPropertyDescriptor((IPropertyDescriptor)propDes);
                ++i;
            }
        }
    }

    public boolean isPropertySet(Object id) {
        boolean isPropSet = false;
        return isPropSet;
    }

    private class ComponentClassController
    extends AbstractPropertySource.AbstractPropertyController {
        private ComponentClassController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            ICompIdentifierPO compId = ((IObjectMappingAssoziationPO)OMTechNameGUIPropertySource.this.getGuiNode()).getTechnicalName();
            if (compId != null && compId.getComponentClassName() != null) {
                return compId.getComponentClassName();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    private class ComponentContextController
    extends AbstractPropertySource.AbstractPropertyController {
        private int m_index = 0;

        public ComponentContextController(int i) {
            this.m_index = i;
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            ICompIdentifierPO compId = ((IObjectMappingAssoziationPO)OMTechNameGUIPropertySource.this.getGuiNode()).getTechnicalName();
            if (compId != null && compId.getSupportedClassName() != null && compId.getNeighbours().get(this.m_index) != null) {
                ArrayList context = new ArrayList(compId.getNeighbours());
                Collections.sort(context);
                return context.get(this.m_index);
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    private class ComponentHierarchyController
    extends AbstractPropertySource.AbstractPropertyController {
        private int m_index = 0;

        public ComponentHierarchyController(int i) {
            this.m_index = i;
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            ICompIdentifierPO compId = ((IObjectMappingAssoziationPO)OMTechNameGUIPropertySource.this.getGuiNode()).getTechnicalName();
            if (compId != null && compId.getSupportedClassName() != null && compId.getHierarchyNames().get(this.m_index) != null) {
                return compId.getHierarchyNames().get(this.m_index);
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    private class ComponentNameController
    extends AbstractPropertySource.AbstractPropertyController {
        private ComponentNameController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            ICompIdentifierPO compId = ((IObjectMappingAssoziationPO)OMTechNameGUIPropertySource.this.getGuiNode()).getTechnicalName();
            if (compId != null && compId.getComponentName() != null) {
                return compId.getComponentName();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return IconConstants.TECHNICAL_NAME_IMAGE;
        }
    }

    private class ComponentPropertiesController
    extends AbstractPropertySource.AbstractPropertyController {
        private int m_index = 0;

        public ComponentPropertiesController(int i) {
            this.m_index = i;
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            Map componentProperties;
            IComponentIdentifier compId = ((IObjectMappingAssoziationPO)OMTechNameGUIPropertySource.this.getGuiNode()).getCompIdentifier();
            if (compId != null && (componentProperties = compId.getComponentPropertiesMap()) != null) {
                ArrayList values = new ArrayList(componentProperties.values());
                return values.get(this.m_index);
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    private class ComponentSuppClassController
    extends AbstractPropertySource.AbstractPropertyController {
        private ComponentSuppClassController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            ICompIdentifierPO compId = ((IObjectMappingAssoziationPO)OMTechNameGUIPropertySource.this.getGuiNode()).getTechnicalName();
            if (compId != null && compId.getSupportedClassName() != null) {
                return compId.getSupportedClassName();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }
}

