/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class PersistableEditorInput
implements IEditorInput {
    private IPersistentObject m_node;
    private EditSupport m_editSupport;

    public PersistableEditorInput(IPersistentObject node) throws PMException {
        this.setNode(node);
        this.m_editSupport = new EditSupport(this.m_node, new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance(), this.m_node));
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.getName());
    }

    public String getName() {
        return StringUtils.defaultString((String)this.m_node.getName());
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == PersistableEditorInput.class) {
            return this;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersistableEditorInput)) {
            return false;
        }
        PersistableEditorInput o = (PersistableEditorInput)obj;
        return this.m_node.equals(o.m_node);
    }

    public int hashCode() {
        return this.m_node.hashCode();
    }

    public IPersistentObject getNode() {
        return this.m_node;
    }

    public EditSupport getEditSupport() {
        return this.m_editSupport;
    }

    public void dispose() {
        this.m_editSupport = null;
        this.m_node = null;
    }

    protected void setNode(IPersistentObject po) {
        Validate.notNull((Object)po, (String)"null value not allowed.");
        this.m_node = po;
    }

    public void refreshNode() {
        this.setNode(this.getEditSupport().getOriginal());
    }
}

