/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.TestCaseTreeDialog;
import org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddExistingEventHandlerHandler
extends AbstractHandler {
    public Object executeImpl(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Assert.verify((boolean)(editor instanceof TestCaseEditor), (String)(String.valueOf(Messages.WrongEditorType) + "!"));
        final TestCaseEditor testCaseEditor = (TestCaseEditor)editor;
        testCaseEditor.getEditorHelper().doEditorOperation(new IEditorOperation(){

            @Override
            public void run(IPersistentObject workingPo) {
                AddExistingEventHandlerHandler.this.openTestCasePopUp(testCaseEditor);
            }
        });
        return null;
    }

    private void openTestCasePopUp(TestCaseEditor editor) {
        ISpecTestCasePO parentNode = (ISpecTestCasePO)editor.getTreeViewer().getTree().getItem(0).getData();
        if (AddExistingEventHandlerHandler.hasTestCaseAllEventHandler(parentNode)) {
            return;
        }
        String title = Messages.AddEventHandlerActionAddEventHandler;
        TestCaseTreeDialog dialog = new TestCaseTreeDialog(this.getActiveShell(), title, "", parentNode, title, 4, IconConstants.ADD_EH_IMAGE);
        final SelectionTransfer selTransferObj = new SelectionTransfer();
        ISelectionListener selListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                selTransferObj.setSelection(selection);
            }
        };
        dialog.addSelectionListener(selListener);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.eventHandlerAddContextId");
        int returnCode = dialog.open();
        if (returnCode == 9999) {
            this.addEventHandler(selTransferObj.getSelection(), (INodePO)parentNode, editor);
        }
        dialog.removeSelectionListener(selListener);
    }

    public static boolean hasTestCaseAllEventHandler(ISpecTestCasePO parentNode) {
        Collection eventTcList = parentNode.getAllEventEventExecTC();
        ArrayList<String> existentEventTypes = new ArrayList<String>();
        for (Object object : eventTcList) {
            IEventExecTestCasePO eventTc = (IEventExecTestCasePO)object;
            existentEventTypes.add(eventTc.getEventType());
        }
        Set mapKeySet = ComponentBuilder.getInstance().getCompSystem().getEventTypes().keySet();
        String[] eventTypes = new String[mapKeySet.size()];
        int i = 0;
        for (Object object : mapKeySet) {
            eventTypes[i] = object.toString();
            ++i;
        }
        List<String> availableEventTypes = Arrays.asList(eventTypes);
        if (availableEventTypes.size() == existentEventTypes.size()) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_ENOUGH_EVENT_HANDLER, null, (String[])new String[]{NLS.bind((String)Messages.AddEventHandlerDialogEnoughEventHandler, (Object)parentNode.getName())});
            return true;
        }
        return false;
    }

    void addEventHandler(ISelection selection, INodePO nodeGUI, TestCaseEditor editor) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        ISpecTestCasePO eventHandler = (ISpecTestCasePO)((IStructuredSelection)selection).getFirstElement();
        editor.addEventHandler(eventHandler, (ISpecTestCasePO)nodeGUI);
    }

    private static class SelectionTransfer {
        private ISelection m_selection = null;

        private SelectionTransfer() {
        }

        public void setSelection(ISelection selection) {
            this.m_selection = selection;
        }

        public ISelection getSelection() {
            return this.m_selection;
        }
    }
}

