/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.utils;

import org.eclipse.jubula.client.ui.rcp.Plugin;

public abstract class JBThread
extends Thread {
    public JBThread() {
        this.addErrorHandler();
    }

    public JBThread(String name) {
        super(name);
        this.addErrorHandler();
    }

    @Override
    public void start() {
        try {
            super.start();
        }
        catch (RuntimeException e) {
            Plugin.getDefault().handleError(e);
            this.errorOccured();
        }
    }

    protected abstract void errorOccured();

    private void addErrorHandler() {
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Plugin.getDefault().handleError(e);
                JBThread.this.errorOccured();
            }
        });
    }
}

