/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.pages;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.ParameterInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.importfilter.DataTable;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.databinding.validators.TestDataManagerNameValidator;
import org.eclipse.jubula.client.ui.rcp.dialogs.AbstractEditParametersDialog;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractEditParametersHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.AddNewTestDataManagerHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.IncompleteDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.internal.ide.filesystem.FileSystemStructureProvider;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ImportXLSTestdataWizardPage
extends WizardResourceImportPage {
    protected static final String SOURCE_EMPTY_MESSAGE = DataTransferMessages.FileImport_sourceEmpty;
    private static final String STORE_SOURCE_NAMES_ID = "WizardFileSystemResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String SELECT_TYPES_TITLE = DataTransferMessages.DataTransfer_selectTypes;
    private static final String SELECT_ALL_TITLE = DataTransferMessages.DataTransfer_selectAll;
    private static final String DESELECT_ALL_TITLE = DataTransferMessages.DataTransfer_deselectAll;
    private static final String SELECT_SOURCE_TITLE = DataTransferMessages.FileImport_selectSourceTitle;
    private static final String SELECT_SOURCE_MESSAGE = DataTransferMessages.FileImport_selectSource;
    private Combo m_sourceNameField;
    private Button m_sourceBrowseButton;
    private Button m_selectTypesButton;
    private Button m_selectAllButton;
    private Button m_deselectAllButton;
    private boolean m_entryChanged = false;
    private FileSystemStructureProvider m_fileSystemStructureProvider = new FileSystemStructureProvider();

    public ImportXLSTestdataWizardPage(String name) {
        super(name, (IStructuredSelection)StructuredSelection.EMPTY);
        this.setTitle(Messages.ImportXLSTestDataWizardTitle);
        this.setDescription(DataTransferMessages.FileImport_importFileSystem);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(parent.getFont());
        GridData buttonData = new GridData(4, 4, true, false);
        buttonComposite.setLayoutData((Object)buttonData);
        this.m_selectTypesButton = this.createButton(buttonComposite, 20, SELECT_TYPES_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportXLSTestdataWizardPage.this.handleTypesEditButtonPressed();
            }
        };
        this.m_selectTypesButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.m_selectTypesButton);
        this.m_selectAllButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportXLSTestdataWizardPage.this.setAllSelections(true);
                ImportXLSTestdataWizardPage.this.updateWidgetEnablements();
            }
        };
        this.m_selectAllButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.m_selectAllButton);
        this.m_deselectAllButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportXLSTestdataWizardPage.this.setAllSelections(false);
                ImportXLSTestdataWizardPage.this.updateWidgetEnablements();
            }
        };
        this.m_deselectAllButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.m_deselectAllButton);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        this.validateSourceGroup();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.file_system_import_wizard_page");
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(this.getSourceLabel());
        groupLabel.setFont(parent.getFont());
        this.m_sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.m_sourceNameField.setLayoutData((Object)data);
        this.m_sourceNameField.setFont(parent.getFont());
        this.m_sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportXLSTestdataWizardPage.this.updateFromSourceField();
            }
        });
        this.m_sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ImportXLSTestdataWizardPage.this.m_entryChanged = true;
                if (e.character == '\r') {
                    ImportXLSTestdataWizardPage.this.m_entryChanged = false;
                    ImportXLSTestdataWizardPage.this.updateFromSourceField();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.m_sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportXLSTestdataWizardPage.this.m_entryChanged) {
                    ImportXLSTestdataWizardPage.this.m_entryChanged = false;
                    ImportXLSTestdataWizardPage.this.updateFromSourceField();
                }
            }
        });
        this.m_sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.m_sourceBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.m_sourceBrowseButton.addListener(13, (Listener)this);
        this.m_sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.m_sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.m_sourceBrowseButton);
    }

    private void updateFromSourceField() {
        this.setSourceName(this.m_sourceNameField.getText());
        this.updateWidgetEnablements();
        this.m_fileSystemStructureProvider.clearVisitedDirs();
    }

    protected MinimizedFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement dummyParent = new MinimizedFileSystemElement("", null, true);
        dummyParent.setPopulated();
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, (FileSystemElement)dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles(provider);
        return dummyParent;
    }

    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createButtonsGroup(parent);
    }

    protected void enableButtonGroup(boolean enable) {
        this.m_selectTypesButton.setEnabled(enable);
        this.m_selectAllButton.setEnabled(enable);
        this.m_deselectAllButton.setEnabled(enable);
    }

    protected boolean ensureSourceIsValid() {
        if (new File(this.getSourceDirectoryName()).isDirectory()) {
            return true;
        }
        this.setErrorMessage(DataTransferMessages.FileImport_invalidSource);
        return false;
    }

    protected boolean executeImportOperation(IRunnableWithProgress op) {
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        return true;
    }

    public boolean finish(IStructuredSelection selection, CentralTestDataEditor ctde) {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        Iterator resourcesEnum = this.getSelectedResources().iterator();
        ArrayList<Object> fileSystemObjects = new ArrayList<Object>();
        while (resourcesEnum.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)resourcesEnum.next()).getFileSystemObject());
        }
        if (fileSystemObjects.size() > 0) {
            return this.importResources(fileSystemObjects, selection, ctde);
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_information, (String)DataTransferMessages.FileImport_noneSelected);
        return false;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFiles((IImportStructureProvider)ImportXLSTestdataWizardPage.this.m_fileSystemStructureProvider).getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, (IImportStructureProvider)this.m_fileSystemStructureProvider);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFolders((IImportStructureProvider)ImportXLSTestdataWizardPage.this.m_fileSystemStructureProvider).getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                return o instanceof MinimizedFileSystemElement;
            }
        };
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.m_sourceNameField.getText());
    }

    private File getSourceDirectory(String path) {
        File sourceDirectory = new File(this.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.m_sourceNameField.getText());
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    protected String getSourceLabel() {
        return DataTransferMessages.FileImport_fromDirectory;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.m_sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.m_sourceNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.m_sourceNameField.getShell(), 0x10002000);
        dialog.setText(SELECT_SOURCE_TITLE);
        dialog.setMessage(SELECT_SOURCE_MESSAGE);
        dialog.setFilterPath(this.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (this.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(selectedDirectory);
            this.selectionGroup.setFocus();
        }
    }

    protected boolean importResources(List fileSystemObjects, IStructuredSelection selection, CentralTestDataEditor ctde) {
        XLSImportOperation operation = new XLSImportOperation(fileSystemObjects, selection, ctde);
        return this.executeImportOperation(operation);
    }

    protected boolean isExportableExtension(String extension) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator itr = this.selectedTypes.iterator();
        while (itr.hasNext()) {
            if (!extension.equalsIgnoreCase((String)itr.next())) continue;
            return true;
        }
        return false;
    }

    protected void resetSelection() {
        MinimizedFileSystemElement currentRoot = this.getFileSystemTree();
        this.selectionGroup.setRoot((Object)currentRoot);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.m_sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.updateWidgetEnablements();
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
        }
    }

    protected MinimizedFileSystemElement selectFiles(final Object rootFileSystemObject, final IImportStructureProvider structureProvider) {
        final MinimizedFileSystemElement[] results = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                results[0] = ImportXLSTestdataWizardPage.this.createRootElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    protected void setAllSelections(boolean value) {
        super.setAllSelections(value);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.m_sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.m_sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.m_sourceNameField.select(selectionIndex);
            this.resetSelection();
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(this.getContainer().getShell());
        final Hashtable selectionMap = new Hashtable();
        final IElementFilter filter = new IElementFilter(){

            public void filterElements(Collection files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                Iterator filesList = files.iterator();
                while (filesList.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(filesList.next());
                }
            }

            public void filterElements(Object[] files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                int i = 0;
                while (i < files.length) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(files[i]);
                    ++i;
                }
            }

            private void checkFile(Object fileElement) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)fileElement;
                if (ImportXLSTestdataWizardPage.this.isExportableExtension(file.getFileNameExtension())) {
                    List<Object> elements = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement parent = file.getParent();
                    if (selectionMap.containsKey(parent)) {
                        elements = (List)selectionMap.get(parent);
                    }
                    elements.add(file);
                    selectionMap.put(parent, elements);
                }
            }
        };
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                monitor.beginTask(DataTransferMessages.ImportPage_filterSelections, -1);
                ImportXLSTestdataWizardPage.this.getSelectedResources(filter, monitor);
            }
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.getShell().update();
        if (selectionMap != null) {
            this.updateSelections(selectionMap);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.resetSelection();
        if (visible) {
            this.m_sourceNameField.setFocus();
        }
    }

    protected void updateSelections(Map map) {
        super.updateSelections(map);
    }

    protected boolean validateSourceGroup() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
            this.setMessage(null);
            this.setErrorMessage(this.getSourceConflictMessage());
            this.enableButtonGroup(false);
            return false;
        }
        List resourcesToExport = this.selectionGroup.getAllWhiteCheckedItems();
        if (resourcesToExport.size() == 0) {
            this.setMessage(null);
            this.setErrorMessage(DataTransferMessages.FileImport_noneSelected);
            return false;
        }
        this.enableButtonGroup(true);
        this.setErrorMessage(null);
        return true;
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    protected boolean sourceConflictsWithDestination(IPath sourcePath) {
        return false;
    }

    private class XLSImportOperation
    implements IRunnableWithProgress {
        private final List m_fileSystemObjects;
        private final IStructuredSelection m_selection;
        private CentralTestDataEditor m_ctde;

        public XLSImportOperation(List fileSystemObjects, IStructuredSelection selection, CentralTestDataEditor ctde) {
            this.m_fileSystemObjects = fileSystemObjects;
            this.m_selection = selection;
            this.m_ctde = ctde;
        }

        public void run(IProgressMonitor monitor) {
            Plugin p = Plugin.getDefault();
            int numerOfFilesToImport = this.m_fileSystemObjects.size();
            String operationDescription = Messages.ImportXLSTestDataWizardImportOperationName;
            monitor.beginTask(operationDescription, numerOfFilesToImport);
            p.writeLine(operationDescription);
            boolean merge = this.m_selection != null && this.m_selection.size() == 1 && numerOfFilesToImport == 1;
            List ll = GeneralStorage.getInstance().getProject().getLangHelper().getLanguageList();
            for (Object o : this.m_fileSystemObjects) {
                if (!(o instanceof File)) continue;
                File f = (File)o;
                String absoluteFilePath = f.getAbsolutePath();
                try {
                    EditSupport es = this.m_ctde.getEditorHelper().getEditSupport();
                    ITestDataCategoryPO cont = (ITestDataCategoryPO)es.getWorkVersion();
                    Set<String> usedNames = AddNewTestDataManagerHandler.getSetOfUsedNames(this.m_ctde);
                    if (merge) {
                        Object selectedObject = this.m_selection.getFirstElement();
                        if (selectedObject instanceof ITestDataCubePO) {
                            ITestDataCubePO tdc = (ITestDataCubePO)selectedObject;
                            tdc.getDataManager().clear();
                            this.fillCentralTestDataSet(f, ll, tdc);
                            this.fireDataChangedEvent((IPersistentObject)tdc, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
                            p.writeLine(NLS.bind((String)Messages.ImportXLSTestDataSuccessfullMerge, (Object[])new Object[]{absoluteFilePath, tdc.getName()}));
                        }
                    } else {
                        String name = f.getName().trim();
                        TestDataManagerNameValidator nameValidator = new TestDataManagerNameValidator(name, usedNames);
                        int counter = 1;
                        while (!nameValidator.validate(name).isOK()) {
                            name = String.valueOf(name) + "_0";
                            name = name.replaceAll("(_[0-9]+)+$", "_" + counter++);
                        }
                        ITestDataCubePO testdata = PoMaker.createTestDataCubePO((String)name);
                        this.fillCentralTestDataSet(f, ll, testdata);
                        cont.addTestData(testdata);
                        p.writeLine(NLS.bind((String)Messages.ImportXLSTestDataWizardSuccessfullImport, (Object[])new Object[]{absoluteFilePath}));
                        this.fireDataChangedEvent((IPersistentObject)testdata, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
                    }
                }
                catch (IncompleteDataException e) {
                    p.writeErrorLine(String.valueOf(absoluteFilePath) + "\n" + e.getLocalizedMessage());
                    monitor.worked(1);
                    continue;
                }
                catch (JBException e) {
                    try {
                        p.writeErrorLine(e.getLocalizedMessage());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
                monitor.worked(1);
            }
            p.writeLine(String.valueOf(Messages.ImportXLSTestDataWizardImportOperationFinished) + "\n");
            monitor.done();
        }

        private void fillCentralTestDataSet(File f, List<Locale> ll, ITestDataCubePO testdata) throws JBException {
            ExternalTestDataBP bp = new ExternalTestDataBP();
            String absoluteFilePath = f.getAbsoluteFile().getAbsolutePath();
            DataTable dtParamInterface = bp.createDataTable(null, absoluteFilePath, WorkingLanguageBP.getInstance().getWorkingLanguage());
            ArrayList<AbstractEditParametersDialog.Parameter> listOfParameters = new ArrayList<AbstractEditParametersDialog.Parameter>();
            int i = 0;
            while (i < dtParamInterface.getColumnCount()) {
                listOfParameters.add(new AbstractEditParametersDialog.Parameter(dtParamInterface.getData(0, i), "java.lang.String"));
                ++i;
            }
            AbstractEditParametersHandler.editParameters(testdata, listOfParameters, this.m_ctde.getEditorHelper().getEditSupport().getParamMapper(), (AbstractParamInterfaceBP<ITestDataCubePO>)new ParameterInterfaceBP());
            boolean firstLocale = true;
            for (Locale loc : ll) {
                bp.clearExternalData();
                DataTable dt = bp.createDataTable(null, absoluteFilePath, loc);
                bp.parseTable(dt, (IParameterInterfacePO)testdata, loc, !firstLocale, true);
                firstLocale = false;
            }
        }

        private void fireDataChangedEvent(final IPersistentObject po, final DataEventDispatcher.DataState datastate, final DataEventDispatcher.UpdateState updatestate) {
            Plugin.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DataEventDispatcher.getInstance().fireDataChangedListener(po, datastate, updatestate);
                }
            });
        }
    }
}

