/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTModeChangedMessage;
import org.eclipse.jubula.communication.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.ServerShowDialogMessage;
import org.eclipse.jubula.communication.message.ServerShowObservConsoleMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeAUTModeCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(ChangeAUTModeCommand.class);
    private ChangeAUTModeMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (ChangeAUTModeMessage)message;
        AUTServerConfiguration autServerConfig = AUTServerConfiguration.getInstance();
        switch (this.m_message.getMode()) {
            case 2: 
            case 3: 
            case 4: {
                autServerConfig.setKeyMod(this.m_message.getKeyModifier());
                autServerConfig.setKey(this.m_message.getKey());
                autServerConfig.setMouseButton(this.m_message.getMouseButton());
                autServerConfig.setKey2Mod(this.m_message.getKey2Modifier());
                autServerConfig.setKey2(this.m_message.getKey2());
                autServerConfig.setCheckModeKeyMod(this.m_message.getCheckModeKeyModifier());
                autServerConfig.setCheckModeKey(this.m_message.getCheckModeKey());
                autServerConfig.setCheckCompKeyMod(this.m_message.getCheckCompKeyModifier());
                autServerConfig.setCheckCompKey(this.m_message.getCheckCompKey());
                autServerConfig.setSingleLineTrigger(this.m_message.getSingleLineTrigger());
                autServerConfig.setMultiLineTrigger(this.m_message.getMultiLineTrigger());
                autServerConfig.setProjectToolkit(this.m_message.getToolkit());
            }
        }
    }

    public Message execute() {
        log.info("changing mode of the AUTServer to: " + this.m_message.getMode());
        int oldMode = AUTServer.getInstance().getMode();
        AUTServer.getInstance().setMode(this.m_message.getMode());
        AUTServer.getInstance().refreshMode();
        ServerShowObservConsoleMessage shellMsg = new ServerShowObservConsoleMessage();
        ServerShowDialogMessage dialogMsg = new ServerShowDialogMessage();
        switch (this.m_message.getMode()) {
            case 4: {
                if (this.m_message.getRecordDialogOpen()) {
                    shellMsg.setAction(1);
                }
                shellMsg.setCheck(true);
                break;
            }
            case 3: {
                if (this.m_message.getRecordDialogOpen()) {
                    shellMsg.setAction(1);
                }
                shellMsg.setCheck(false);
                break;
            }
            default: {
                shellMsg.setAction(2);
                dialogMsg.setAction(4);
            }
        }
        try {
            AUTServer.getInstance().getServerCommunicator().send((Message)shellMsg);
            if (this.m_message.getMode() != oldMode && this.m_message.getMode() == 1) {
                AUTServer.getInstance().getServerCommunicator().send((Message)dialogMsg);
            }
        }
        catch (CommunicationException communicationException) {}
        AUTModeChangedMessage result = new AUTModeChangedMessage();
        result.setMode(AUTServer.getInstance().getMode());
        return result;
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

