/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int NUM_COLUMNS = 1;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private static final int MARGIN_HEIGHT_10 = 10;
    private static final int MARGIN_WIDTH_10 = 10;
    private Button m_nodeInsertButton;
    private Button m_nodeAddButton;
    private IPreferenceStore m_store = Plugin.getDefault().getPreferenceStore();

    public EditorPreferencePage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.compositeGridData(composite);
        this.createInsertNodeAfterSelectedNodeButton(composite);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.editorPrefPageContextId");
        return composite;
    }

    private void createInsertNodeAfterSelectedNodeButton(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.PrefPageBasicNodeInsertionGroup);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        group.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)layoutData);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.EditorPreferencePageAddPositionText);
        new Label((Composite)group, 0);
        this.m_nodeAddButton = new Button((Composite)group, 16);
        this.m_nodeAddButton.setText(Messages.PrefPageBasicAddNewNode);
        this.m_nodeAddButton.setSelection(Plugin.getDefault().getPreferenceStore().getBoolean("NODE_INSERT_KEY"));
        this.m_nodeInsertButton = new Button((Composite)group, 16);
        this.m_nodeInsertButton.setText(Messages.PrefPageBasicInsertNewNode);
        this.m_nodeInsertButton.setSelection(!this.m_nodeAddButton.getSelection());
    }

    private void compositeGridData(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)compositeData);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.EditorPreferencePageDescription);
    }

    protected void performDefaults() {
        this.m_nodeInsertButton.setSelection(this.m_store.getDefaultBoolean("NODE_INSERT_KEY"));
        this.m_nodeAddButton.setSelection(!this.m_store.getDefaultBoolean("NODE_INSERT_KEY"));
    }

    public boolean performOk() {
        Plugin.getDefault().getPreferenceStore().setValue("NODE_INSERT_KEY", this.m_nodeAddButton.getSelection());
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
    }
}

