/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.core.errorhandling.IDatabaseVersionErrorHandler;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ImportFileBP;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.pages.DatabaseMigrationAssistantIntroPage;
import org.eclipse.jubula.client.ui.rcp.wizards.pages.ImportProjectsWizardPage;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMigrationAssistant
extends Wizard
implements IDatabaseVersionErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseMigrationAssistant.class);
    private static final String INTRO_PAGE_ID = "DatabaseMigrationAssistant.IntroPage";
    private boolean m_wasMigrationSuccessful = false;
    private ImportProjectsWizardPage m_importProjectsPage;

    public DatabaseMigrationAssistant() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Database Migration Assistant");
    }

    public boolean handleDatabaseError() {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)Plugin.getShell(), (String)Messages.DatabaseMigrationAssistantIntroPageTitle, (String)Messages.DatabaseMigrationAssistantIntroPageText);
            }
        });
        return this.m_wasMigrationSuccessful;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new DatabaseMigrationAssistantIntroPage(INTRO_PAGE_ID));
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    monitor.beginTask("Migrating...", -1);
                    try {
                        try {
                            DatabaseMigrationAssistant.this.m_wasMigrationSuccessful = Persistor.migrateDatabaseStructure();
                            ImportFileBP.getInstance().importProjects(DatabaseMigrationAssistant.this.m_importProjectsPage, monitor);
                            Plugin.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    NagDialog.runNagDialog(null, Messages.DatabaseMigrationAssistantFinalInfo, "org.eclipse.jubula.client.ua.help.databaseMigrationAssistantContextId");
                                }
                            });
                        }
                        catch (JBFatalException e) {
                            LOG.error(String.valueOf(Messages.AnErrorOccurredDuringMigration) + ".", (Throwable)e);
                            monitor.done();
                        }
                        catch (JBException e) {
                            LOG.error(String.valueOf(Messages.AnErrorOccurredDuringMigration) + ".", (Throwable)e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            LOG.error(String.valueOf(Messages.AnErrorOccurredDuringMigration) + ".", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error(String.valueOf(Messages.AnErrorOccurredDuringMigration) + ".", (Throwable)e);
        }
        return true;
    }

    public int getMinimumDatabaseMajorVersionNumber() {
        return 34;
    }
}

