/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.WidgetTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITabbedComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class TabbedPaneTester
extends WidgetTester {
    public ITabbedComponent getTabPane() {
        return (ITabbedComponent)this.getComponent();
    }

    private int getIndexOfTab(String title, String operator) {
        int index = -1;
        int tabs = this.getTabPane().getTabCount();
        int a = 0;
        while (a < tabs) {
            if (MatchUtil.getInstance().match(this.getTabPane().getTitleofTab(a), title, operator)) {
                index = a;
                break;
            }
            ++a;
        }
        if (index == -1) {
            throw new StepExecutionException("Can not find tab: '" + title + "' using operator: '" + operator + "'", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return index;
    }

    protected void verifyIndexExists(int index) {
        boolean exists;
        boolean bl = exists = index >= 0 && index < this.getTabPane().getTabCount();
        if (!exists) {
            throw new StepExecutionException("The tab index doesn't exist: " + index, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public String[] getTextArrayFromComponent() {
        String[] componentTextArray = new String[this.getTabPane().getTabCount()];
        int i = 0;
        while (i < componentTextArray.length) {
            componentTextArray[i] = this.getTabPane().getTitleofTab(i);
            ++i;
        }
        return componentTextArray;
    }

    private void selectTabByImplIndex(int index) {
        this.verifyIndexExists(index);
        this.getRobot().click(this.getTabPane().getRealComponent(), this.getTabPane().getBoundsAt(index), ClickOptions.create().left(), 25, false, 50, false);
    }

    public void rcSelectTabByIndex(int index) throws StepExecutionException {
        int implIdx = IndexConverter.toImplementationIndex(index);
        this.selectTabByImplIndex(implIdx);
    }

    public void rcSelectTab(String title, String operator) throws StepExecutionException {
        this.selectTabByImplIndex(this.getIndexOfTab(title, operator));
    }

    public void rcVerifyTextOfTabByIndex(int index, String text, String operator) throws StepExecutionException {
        int tabIndex = IndexConverter.toImplementationIndex(index);
        String tabTitle = this.getTabPane().getTitleofTab(tabIndex);
        Verifier.match(tabTitle, text, operator);
    }

    public void rcVerifyExistenceOfTab(String tab, String operator, boolean exists) throws StepExecutionException {
        int tabIdx = this.getTabIndexFromString(tab, operator);
        boolean tabExists = true;
        try {
            this.verifyIndexExists(tabIdx);
        }
        catch (StepExecutionException stepExecutionException) {
            tabExists = false;
        }
        Verifier.equals(exists, tabExists);
    }

    /*
     * Unable to fully structure code
     */
    private int getTabIndexFromString(String tab, String operator) {
        block4: {
            tabIndex = -1;
            try {
                tabIndex = IndexConverter.toImplementationIndex(Integer.parseInt(tab));
                break block4;
            }
            catch (NumberFormatException v0) {
                i = 0;
                ** while (i < this.getTabPane().getTabCount())
            }
lbl-1000:
            // 1 sources

            {
                text = this.getTabPane().getTitleofTab(i);
                if (MatchUtil.getInstance().match(text, tab, operator)) {
                    return i;
                }
                ++i;
                continue;
            }
        }
        return tabIndex;
    }

    public void rcVerifyEnabled(String title, String operator, boolean isEnabled) throws StepExecutionException {
        int tabIndex = this.getIndexOfTab(title, operator);
        Verifier.equals(isEnabled, this.getTabPane().isEnabledAt(tabIndex));
    }

    public void rcVerifyEnabledByIndex(int index, boolean enabled) throws StepExecutionException {
        int implIdx = IndexConverter.toImplementationIndex(index);
        this.verifyIndexExists(implIdx);
        Verifier.equals(enabled, this.getTabPane().isEnabledAt(implIdx));
    }

    public void rcVerifySelectedTabByIndex(int index, boolean selected) throws StepExecutionException {
        int implIdx = IndexConverter.toImplementationIndex(index);
        int selIndex = this.getTabPane().getSelectedIndex();
        if (selIndex == -1) {
            if (!selected) {
                return;
            }
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoSelection"), EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        Verifier.equals(selected, selIndex == implIdx);
    }

    public void rcVerifySelectedTab(String tabTitlePattern, String operator, boolean selected) throws StepExecutionException {
        String selectedTabTitle = null;
        int selectedIndex = this.getTabPane().getSelectedIndex();
        if (selectedIndex >= 0) {
            selectedTabTitle = this.getTabPane().getTitleofTab(selectedIndex);
        }
        if (selectedTabTitle == null) {
            if (!selected) {
                return;
            }
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoSelection"), EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        Verifier.match(selectedTabTitle, tabTitlePattern, operator, selected);
    }
}

