/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.jubula.client.api.converter.NodeInfo;
import org.eclipse.jubula.client.api.converter.exceptions.InvalidNodeNameException;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CommonGenInfo;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String EXEC_PATH = "testsuites";
    public static final String SPEC_PATH = "testcases";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("^[A-Z][\\w]*$");
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("^[a-z0-9_]*$");
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static String getFullyQualifiedName(INodePO node) {
        String name = node.getName();
        INodePO parentNode = node.getParentNode();
        if (parentNode != null) {
            name = String.valueOf(Utils.getFullyQualifiedName(parentNode)) + "/" + name;
        }
        return name;
    }

    private static String getFullyQualifiedTranslatedNameWithoutPrefix(INodePO node) {
        String name = "";
        try {
            name = node instanceof ICategoryPO ? Utils.translateToPackageName(node) : Utils.determineClassName((IPersistentObject)node);
        }
        catch (InvalidNodeNameException e) {
            LOG.error(e.getLocalizedMessage());
        }
        INodePO parentNode = node.getParentNode();
        if (parentNode != null && parentNode.getParentNode() != null) {
            name = String.valueOf(Utils.getFullyQualifiedTranslatedNameWithoutPrefix(parentNode)) + "." + name;
        }
        return name;
    }

    public static String getFullyQualifiedTranslatedName(INodePO node, String packageBasePath, String projectName) {
        String name = String.valueOf(Utils.getProjectPath(packageBasePath, projectName)) + ".";
        name = node instanceof ISpecTestCasePO ? String.valueOf(name) + SPEC_PATH : String.valueOf(name) + EXEC_PATH;
        return String.valueOf(name) + "." + Utils.getFullyQualifiedTranslatedNameWithoutPrefix(node);
    }

    public static String getProjectPath(String packageBasePath, String projectName) {
        String name = String.valueOf(packageBasePath) + "." + projectName;
        return name;
    }

    public static String translateToPackageName(INodePO node) throws InvalidNodeNameException {
        String name = node.getName();
        name = Utils.removeInvalidCharacters(name);
        name = Utils.replaceUmlauts(name);
        name = name.toLowerCase();
        name = StringUtils.deleteWhitespace((String)name);
        if (!PACKAGE_NAME_PATTERN.matcher(name = name.replaceAll("^[0-9]*", "")).matches() || Utils.isInvalid(name)) {
            throw new InvalidNodeNameException();
        }
        return name;
    }

    private static boolean isInvalid(String name) {
        String[] invalidPhrases;
        String[] stringArray = invalidPhrases = new String[]{"public", "private", "protected", "static"};
        int n = invalidPhrases.length;
        int n2 = 0;
        while (n2 < n) {
            String phrase = stringArray[n2];
            if (phrase.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String determineClassName(IPersistentObject node) throws InvalidNodeNameException {
        String name = node.getName();
        name = Utils.removeInvalidCharacters(name);
        name = Utils.replaceUmlauts(name);
        name = WordUtils.capitalize((String)name);
        name = StringUtils.deleteWhitespace((String)name);
        if (!CLASS_NAME_PATTERN.matcher(name = name.replaceAll("^[0-9_]*", "")).matches()) {
            throw new InvalidNodeNameException();
        }
        return name;
    }

    private static String replaceUmlauts(String name) {
        String adjustedName = name;
        adjustedName = adjustedName.replace("\u00e4", "ae");
        adjustedName = adjustedName.replace("\u00f6", "oe");
        adjustedName = adjustedName.replace("\u00fc", "ue");
        adjustedName = adjustedName.replace("\u00c4", "Ae");
        adjustedName = adjustedName.replace("\u00d6", "Oe");
        adjustedName = adjustedName.replace("\u00dc", "Ue");
        adjustedName = adjustedName.replace("\u00df", "ss");
        return adjustedName;
    }

    private static String removeInvalidCharacters(String name) {
        String[] invalidChars;
        String adjustedName = name;
        String[] stringArray = invalidChars = new String[]{"&", "'", "\\", ":", ",", ".", "=", "!", "[", "<", "(", "-", "|", "+", "?", "\"", "]", ">", ")", ";", "/", "*"};
        int n = invalidChars.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            adjustedName = adjustedName.replace(c, " ");
            ++n2;
        }
        return adjustedName;
    }

    public static String getFactoryName(String toolkit) {
        ToolkitDescriptor toolkitDescriptor = ComponentBuilder.getInstance().getCompSystem().getToolkitDescriptor(toolkit);
        CommonGenInfo defaultFactoryInfo = new CommonGenInfo(toolkitDescriptor, false);
        String name = defaultFactoryInfo.getFqClassName();
        return name;
    }

    public static void fillCTDSList(ITestDataCategoryPO root, List<ITestDataCubePO> list) {
        list.addAll(root.getTestDataChildren());
        for (ITestDataCategoryPO cat : root.getCategoryChildren()) {
            Utils.fillCTDSList(cat, list);
        }
    }

    public static List<String> determineCompIdentifierList(ComponentNamesBP componentNamesBP, CompNamesBP compNamesBP, IExecTestCasePO exec) {
        List childCompNamePairs = compNamesBP.getAllCompNamesPairs(exec);
        Iterator childCompNamePairsIterator = childCompNamePairs.iterator();
        ArrayList<String> childCompIdentifierNames = new ArrayList<String>();
        while (childCompNamePairsIterator.hasNext()) {
            ICompNamesPairPO pair = (ICompNamesPairPO)childCompNamePairsIterator.next();
            String compIdentifierName = componentNamesBP.getName(pair.getSecondName());
            if (StringUtils.isBlank((String)compIdentifierName)) continue;
            if (pair.isPropagated()) {
                childCompIdentifierNames.add(compIdentifierName);
                continue;
            }
            childCompIdentifierNames.add("rtc.getIdentifier(\"" + compIdentifierName + "\")");
        }
        return childCompIdentifierNames;
    }

    public static void classifyImport(String className, List<NodeInfo> classesToImport, List<NodeInfo> duplicateClasses, NodeInfo childInfo) {
        if (childInfo.getClassName().equals(className)) {
            duplicateClasses.add(childInfo);
            return;
        }
        for (NodeInfo duplicate : duplicateClasses) {
            if (!duplicate.getClassName().equals(childInfo.getClassName())) continue;
            return;
        }
        for (NodeInfo classToImport : classesToImport) {
            if (!classToImport.getClassName().equals(childInfo.getClassName())) continue;
            if (classToImport == childInfo) {
                return;
            }
            classesToImport.remove(classToImport);
            duplicateClasses.add(classToImport);
            return;
        }
        classesToImport.add(childInfo);
    }
}

