/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.ui.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.internal.utils.SerilizationUtils;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;

public class OMExport {
    private String m_targetClassName;
    private Map<String, String> m_objectMapping;

    public OMExport(Map<String, String> map, String fileName) {
        this.setObjectMapping(map);
        this.setTargetClassName(fileName);
    }

    public String getTargetClassName() {
        return this.m_targetClassName;
    }

    private void setTargetClassName(String name) {
        this.m_targetClassName = name;
    }

    public Map<String, String> createIdentifierMap() {
        HashMap<String, String> identifierMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getObjectMapping().entrySet()) {
            String key = entry.getKey();
            identifierMap.put(key, this.translateToJavaIdentifier(key));
        }
        return identifierMap;
    }

    public StringBuffer createEncodedAssociations() {
        StringBuffer encodedAssociations = new StringBuffer();
        HashMap<String, String> identifierMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getObjectMapping().entrySet()) {
            String key = entry.getKey();
            encodedAssociations.append(key);
            encodedAssociations.append("=");
            encodedAssociations.append(entry.getValue());
            encodedAssociations.append("\n");
            identifierMap.put(key, this.translateToJavaIdentifier(key));
        }
        return encodedAssociations;
    }

    private String translateToJavaIdentifier(String key) {
        String[] exceptions;
        String modifiedKey = key;
        String[] stringArray = exceptions = new String[]{".", " ", "\\", "/", "*", ":", "[", "]", "(", ")", "=", "+", "-", "|"};
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            String exception = stringArray[n2];
            modifiedKey = modifiedKey.replace(exception, "_");
            ++n2;
        }
        return modifiedKey;
    }

    public Map<String, String> getObjectMapping() {
        return this.m_objectMapping;
    }

    private void setObjectMapping(Map<String, String> objectMapping) {
        this.m_objectMapping = objectMapping;
    }

    public static String getSerialization(ComponentIdentifier identifier) throws IOException {
        return SerilizationUtils.encode((Serializable)identifier);
    }
}

