/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.apache.commons.collections.IteratorUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestCaseParamBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.businessprocess.db.TimestampBP;
import org.eclipse.jubula.client.core.commands.CAPRecordedCommand;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ITimestampPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.constants.RCPCommandIDs;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TreeViewerContainerDragSourceListener;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.DecoratingCellLabelProvider;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.TestCaseEditorContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.TooltipLabelProvider;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractTestCaseEditor
extends AbstractJBEditor
implements DataEventDispatcher.IParamChangedListener {
    @Override
    public void createPartControlImpl(Composite parent) {
        this.createSashForm(parent);
        this.setParentComposite(parent);
        this.setInitialInput();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        DecoratingCellLabelProvider lp = new DecoratingCellLabelProvider(new TooltipLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addPropertyChangedListener((DataEventDispatcher.IPropertyChangedListener)this, true);
        this.addDragAndDropSupport(2, new Transfer[]{LocalSelectionTransfer.getInstance()});
        this.getEditorHelper().addListeners();
        this.setActionHandlers();
        this.addDoubleClickListener("org.eclipse.jubula.client.ui.commands.OpenSpecification", (StructuredViewer)this.getMainTreeViewer());
        GuiEventDispatcher.getInstance().addEditorDirtyStateListener(this, true);
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)new CentralTestDataUpdateListener(), false);
        ded.addParamChangedListener((DataEventDispatcher.IParamChangedListener)this, true);
    }

    protected void addDragAndDropSupport(int operations, Transfer[] transfers) {
        this.getMainTreeViewer().addDragSupport(operations, transfers, (DragSourceListener)new TreeViewerContainerDragSourceListener(this.getTreeViewer()));
        this.getMainTreeViewer().addDropSupport(operations, transfers, this.getViewerDropAdapter());
    }

    protected abstract DropTargetListener getViewerDropAdapter();

    protected SashForm createSashForm(Composite parent) {
        SashForm sashForm = new SashForm(parent, 514);
        GridLayout compLayout = new GridLayout(1, true);
        compLayout.marginWidth = 0;
        compLayout.marginHeight = 0;
        sashForm.setLayout((Layout)compLayout);
        GridData gridData = new GridData(1808);
        sashForm.setLayoutData((Object)gridData);
        this.setControl((Control)sashForm);
        this.createMainPart((Composite)sashForm);
        return sashForm;
    }

    @Override
    public void setInitialInput() {
        this.getMainTreeViewer().setContentProvider((IContentProvider)new TestCaseEditorContentProvider());
        INodePO workVersion = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        this.initTopTreeViewer(workVersion);
        this.runLocalChecks();
    }

    protected void runLocalChecks() {
        INodePO node = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        for (INodePO child : node.getUnmodifiableNodeList()) {
            CompletenessGuard.checkLocalTestData((INodePO)child, (Locale)WorkingLanguageBP.getInstance().getWorkingLanguage());
        }
    }

    protected void initTopTreeViewer(INodePO root) {
        try {
            this.getMainTreeViewer().getTree().setRedraw(false);
            this.getMainTreeViewer().setInput(null);
            this.getMainTreeViewer().setInput((Object)new INodePO[]{root});
        }
        finally {
            this.getMainTreeViewer().getTree().setRedraw(true);
            this.getMainTreeViewer().expandAll();
            this.setSelection((ISelection)new StructuredSelection((Object)root));
        }
    }

    /*
     * Loose catch block
     */
    public void doSave(IProgressMonitor monitor) {
        if (!this.checkCompleteness()) {
            return;
        }
        monitor.beginTask(Messages.EditorsSaveEditors, -1);
        try {
            try {
                EditSupport editSupport = this.getEditorHelper().getEditSupport();
                this.removeIncorrectCompNamePairs();
                this.fixCompNameReferences();
                IPersistentObject perObj = editSupport.getWorkVersion();
                IWritableComponentNameCache compNameCache = editSupport.getCompMapper().getCompNameCache();
                HashSet renamedCompNames = new HashSet(compNameCache.getRenamedNames());
                HashSet<IComponentNamePO> reuseChangedCompNames = new HashSet<IComponentNamePO>();
                for (String compNameGuid : compNameCache.getReusedNames()) {
                    IComponentNamePO compName = compNameCache.getCompNamePo(compNameGuid);
                    if (compName == null) continue;
                    reuseChangedCompNames.add(compName);
                }
                if (perObj instanceof ISpecTestCasePO) {
                    IProjectPO project = GeneralStorage.getInstance().getProject();
                    UsedToolkitBP.getInstance().addToolkit((ISpecTestCasePO)perObj, project);
                }
                TimestampBP.refreshTimestamp((ITimestampPO)((ITimestampPO)perObj));
                editSupport.saveWorkVersion();
                this.updateObjectMapping();
                ArrayList<DataChangedEvent> eventList = new ArrayList<DataChangedEvent>();
                for (IComponentNamePO compName : renamedCompNames) {
                    eventList.add(new DataChangedEvent((IPersistentObject)compName, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all));
                }
                for (IComponentNamePO compName : reuseChangedCompNames) {
                    eventList.add(new DataChangedEvent((IPersistentObject)compName, DataEventDispatcher.DataState.ReuseChanged, DataEventDispatcher.UpdateState.all));
                }
                DataEventDispatcher.getInstance().fireDataChangedListener(eventList.toArray(new DataChangedEvent[0]));
                this.getEditorHelper().resetEditableState();
                this.getEditorHelper().setDirty(false);
            }
            catch (IncompatibleTypeException pmce) {
                this.handlePMCompNameException(pmce);
                monitor.done();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
                try {
                    this.reOpenEditor((IPersistentObject)((NodeEditorInput)this.getEditorInput()).getNode());
                }
                catch (PMException pMException) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, this);
                }
                monitor.done();
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fixCompNameReferences() {
        INodePO rootNode = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        IWritableComponentNameCache compNameCache = this.getEditorHelper().getEditSupport().getCompMapper().getCompNameCache();
        Iterator iter = rootNode.getNodeListIterator();
        while (iter.hasNext()) {
            ICapPO capPo;
            String compNameGuid;
            IComponentNamePO compNamePo;
            INodePO nodePO = (INodePO)iter.next();
            if (nodePO instanceof IExecTestCasePO) {
                IExecTestCasePO exec = (IExecTestCasePO)nodePO;
                ArrayList<String> toRemove = new ArrayList<String>();
                ArrayList<ICompNamesPairPO> toAdd = new ArrayList<ICompNamesPairPO>();
                for (ICompNamesPairPO pair : exec.getCompNamesPairs()) {
                    String firstName = pair.getFirstName();
                    String secondName = pair.getSecondName();
                    IComponentNamePO firstCompNamePo = compNameCache.getCompNamePo(firstName);
                    IComponentNamePO secondCompNamePo = compNameCache.getCompNamePo(secondName);
                    if (firstCompNamePo.getGuid().equals(firstName) && secondCompNamePo.getGuid().equals(secondName)) continue;
                    String componentType = pair.getType();
                    toRemove.add(firstName);
                    toAdd.add(PoMaker.createCompNamesPairPO((String)firstCompNamePo.getGuid(), (String)secondCompNamePo.getGuid(), (String)componentType));
                }
                for (String stringToRemove : toRemove) {
                    exec.removeCompNamesPair(stringToRemove);
                }
                for (ICompNamesPairPO pairToAdd : toAdd) {
                    exec.addCompNamesPair(pairToAdd);
                }
                continue;
            }
            if (!(nodePO instanceof ICapPO) || (compNamePo = compNameCache.getCompNamePo(compNameGuid = (capPo = (ICapPO)nodePO).getComponentName())) == null || compNamePo.getGuid().equals(compNameGuid)) continue;
            capPo.setComponentName(compNamePo.getGuid());
        }
        CompNamePM.removeUnusedCompNames((Long)GeneralStorage.getInstance().getProject().getId(), (EntityManager)this.getEditorHelper().getEditSupport().getSession());
    }

    private void removeIncorrectCompNamePairs() {
        INodePO node = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        if (node instanceof ISpecTestCasePO || node instanceof ITestSuitePO) {
            for (Object o : node.getUnmodifiableNodeList()) {
                ICompNamesPairPO[] pairArray;
                if (!(o instanceof IExecTestCasePO)) continue;
                IExecTestCasePO exec = (IExecTestCasePO)o;
                ICompNamesPairPO[] iCompNamesPairPOArray = pairArray = exec.getCompNamesPairs().toArray(new ICompNamesPairPO[exec.getCompNamesPairs().size()]);
                int n = pairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompNamesPairPO pair = iCompNamesPairPOArray[n2];
                    this.searchAndSetComponentType(pair);
                    if (!CompNamesBP.isValidCompNamePair((ICompNamesPairPO)pair)) {
                        exec.removeCompNamesPair(pair.getFirstName());
                    }
                    ++n2;
                }
            }
        } else {
            LOG.error(String.valueOf(Messages.WrongEditSupportInTestCaseEditor) + ":" + " " + node);
        }
    }

    private void searchAndSetComponentType(ICompNamesPairPO pair) {
        Object selectedElement;
        if (pair.getType() != null && CompNamesBP.isValidCompNamePair((ICompNamesPairPO)pair)) {
            return;
        }
        IPersistentObject orig = this.getEditorHelper().getEditSupport().getOriginal();
        if (orig instanceof ISpecTestCasePO || orig instanceof ITestSuitePO) {
            INodePO origNode = (INodePO)orig;
            for (Object node : origNode.getUnmodifiableNodeList()) {
                if (!CompNamesBP.searchCompType((ICompNamesPairPO)pair, node)) continue;
                return;
            }
        }
        if (!((selectedElement = this.getStructuredSelection().getFirstElement()) == null || pair.getType() != null && CompNamesBP.isValidCompNamePair((ICompNamesPairPO)pair))) {
            CompNamesBP.searchCompType((ICompNamesPairPO)pair, (Object)selectedElement);
        }
    }

    protected boolean checkCompleteness() {
        ISpecTestCasePO testCase = (ISpecTestCasePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        Integer mId = MessageIDs.E_CANNOT_SAVE_EDITOR_TC_SP;
        if (testCase.getName() == null || "".equals(testCase.getName())) {
            ErrorHandlingUtil.createMessageDialog((Integer)mId, null, (String[])new String[]{Messages.TestCaseEditorNoTcName});
            return false;
        }
        if (testCase.getName().startsWith(" ") || testCase.getName().endsWith(" ")) {
            ErrorHandlingUtil.createMessageDialog((Integer)mId, null, (String[])new String[]{Messages.TestCaseEditorWrongTcName});
            return false;
        }
        Iterator iter = testCase.getNodeListIterator();
        while (iter.hasNext()) {
            Object node = iter.next();
            if (!(node instanceof ICapPO)) continue;
            ICapPO cap = (ICapPO)node;
            if (cap.getName() == null || "".equals(cap.getName())) {
                ErrorHandlingUtil.createMessageDialog((Integer)mId, null, (String[])new String[]{Messages.TestCaseEditorNoCapName});
                return false;
            }
            if (cap.getName().startsWith(" ") || cap.getName().endsWith(" ")) {
                ErrorHandlingUtil.createMessageDialog((Integer)mId, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorWrongTsName, (Object)cap.getName())});
                return false;
            }
            if (this.componentHasDefaultMapping(cap)) continue;
            if (cap.getComponentName() == null || "".equals(cap.getComponentName())) {
                ErrorHandlingUtil.createMessageDialog((Integer)mId, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorNoCompName, (Object)cap.getName())});
                return false;
            }
            if (!cap.getComponentName().startsWith(" ") && !cap.getComponentName().endsWith(" ")) continue;
            ErrorHandlingUtil.createMessageDialog((Integer)mId, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorWrongCompName2, (Object)cap.getName())});
            return false;
        }
        for (Object object : testCase.getAllEventEventExecTC()) {
            IEventExecTestCasePO eventTC = (IEventExecTestCasePO)object;
            if ("".equals(eventTC.getName())) {
                ErrorHandlingUtil.createMessageDialog((Integer)mId, null, (String[])new String[]{Messages.TestCaseEditorNoEventTcName});
                return false;
            }
            if (!eventTC.getName().startsWith(" ") && !eventTC.getName().endsWith(" ")) continue;
            ErrorHandlingUtil.createMessageDialog((Integer)mId, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorWrongEhName, (Object)eventTC.getName())});
            return false;
        }
        return this.checkRefsAndCompNames(testCase);
    }

    private boolean componentHasDefaultMapping(ICapPO cap) {
        Component component = ComponentBuilder.getInstance().getCompSystem().findComponent(cap.getComponentType());
        if (component.isConcrete()) {
            return ((ConcreteComponent)component).hasDefaultMapping();
        }
        return false;
    }

    @Override
    protected void checkMasterSessionUpToDate() {
        super.checkMasterSessionUpToDate();
        ITimestampPO node = (ITimestampPO)this.getEditorHelper().getEditSupport().getWorkVersion();
        TimestampBP.refreshEditorNodeInMasterSession((ITimestampPO)node);
    }

    private boolean checkRefsAndCompNames(ISpecTestCasePO testCase) {
        ITDManager mgr = testCase.getDataManager();
        Locale locale = WorkingLanguageBP.getInstance().getWorkingLanguage();
        int row = 0;
        while (row < mgr.getDataSetCount()) {
            IDataSetPO row2 = mgr.getDataSet(row);
            int col = 0;
            while (col < row2.getColumnCount()) {
                String uniqueId;
                IParamDescriptionPO desc;
                ITestDataPO data = row2.getColumn(col);
                ModelParamValueConverter conv = new ModelParamValueConverter(data, (IParameterInterfacePO)testCase, locale, desc = testCase.getParameterForUniqueId(uniqueId = (String)mgr.getUniqueIds().get(col)));
                Iterator iterator = conv.getNamesForReferences().iterator();
                if (iterator.hasNext()) {
                    String refName = (String)iterator.next();
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_CANNOT_SAVE_EDITOR_TC_SP, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorContReference, (Object)refName)});
                    return false;
                }
                ++col;
            }
            ++row;
        }
        Iterator iter = testCase.getNodeListIterator();
        while (iter.hasNext()) {
            INodePO nodePO = (INodePO)iter.next();
            if (!(nodePO instanceof IExecTestCasePO)) continue;
            IExecTestCasePO exec = (IExecTestCasePO)nodePO;
            for (ICompNamesPairPO pair : exec.getCompNamesPairs()) {
                if (pair.getSecondName() != null && !"".equals(pair.getSecondName())) continue;
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_CANNOT_SAVE_EDITOR_TC_SP, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorMmissingCompName, (Object[])new Object[]{StringHelper.getInstance().getMap().get(pair.getType()), pair.getFirstName(), exec.getName()})});
                return false;
            }
        }
        return true;
    }

    private void updateObjectMapping() {
        INodePO rootInput = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        for (INodePO node : rootInput.getUnmodifiableNodeList()) {
            if (!(node instanceof ISpecTestCasePO)) continue;
            ObjectMappingEventDispatcher.notifyRecordObserver((ISpecTestCasePO)((ISpecTestCasePO)node));
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager mgr) {
        if (this.getStructuredSelection().getFirstElement() == null) {
            return;
        }
        MenuManager submenuAdd = new MenuManager(Messages.TestSuiteBrowserAdd, "org.eclipse.ui.AddSubMenu");
        MenuManager submenuRefactor = new MenuManager(Messages.TestCaseEditorRefactor, "org.eclipse.ui.RefactorSubMenu");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.newTestCaseReference");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.newCap");
        mgr.add((IContributionItem)submenuAdd);
        mgr.add((IAction)this.getCutTreeItemAction());
        mgr.add((IAction)this.getPasteTreeItemAction());
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.ToggleActiveStatus");
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.EditParameters");
        mgr.add((IContributionItem)new GroupMarker("editing"));
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.RevertChanges");
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)submenuRefactor);
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.ui.edit.delete");
        mgr.add(CommandHelper.createContributionItem((String)RCPCommandIDs.FIND, null, (String)Messages.FindContextMenu, (int)8));
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.OpenSpecification");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.ShowSpecification");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.ShowWhereUsed");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.ExpandTreeItem");
        CommandHelper.createContributionPushItem((IMenuManager)submenuAdd, (String)"org.eclipse.jubula.client.ui.rcp.commands.NewTestCaseCommand");
        CommandHelper.createContributionPushItem((IMenuManager)submenuAdd, (String)"org.eclipse.jubula.client.ui.rcp.commands.AddEventHandler");
        CommandHelper.createContributionPushItem((IMenuManager)submenuRefactor, (String)"org.eclipse.jubula.client.ui.rcp.commands.ExtractTestCase");
        CommandHelper.createContributionPushItem((IMenuManager)submenuRefactor, (String)"org.eclipse.jubula.client.ui.rcp.commands.ReplaceWithTestCase");
        CommandHelper.createContributionPushItem((IMenuManager)submenuRefactor, (String)"org.eclipse.jubula.client.ui.rcp.commands.SaveAsNew");
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    @Override
    public void dispose() {
        try {
            DataEventDispatcher ded = DataEventDispatcher.getInstance();
            if (CAPRecordedCommand.getRecordListener() == this) {
                CAPRecordedCommand.setRecordListener(null);
                TestExecutionContributor.getInstance().getClientTest().resetToTesting();
            }
            if (this.getEditorSite() != null && this.getEditorSite().getPage() != null) {
                ded.fireRecordModeStateChanged(DataEventDispatcher.RecordModeState.notRunning);
                this.removeGlobalActionHandler();
            }
            ded.removeParamChangedListener((DataEventDispatcher.IParamChangedListener)this);
        }
        finally {
            super.dispose();
        }
    }

    private void removeGlobalActionHandler() {
        this.getEditorSite().getActionBars().updateActionBars();
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    @Override
    public void handlePropertyChanged(boolean isCompNameChanged) {
        super.handlePropertyChanged(isCompNameChanged);
        this.runLocalChecks();
    }

    public void handleParamChanged() {
        this.runLocalChecks();
        this.refresh();
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (po instanceof INodePO) {
            boolean isVisibleInEditor;
            INodePO changedNode = (INodePO)po;
            INodePO editorNode = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
            boolean bl = isVisibleInEditor = editorNode.indexOf(changedNode) > -1;
            if (editorNode instanceof ISpecTestCasePO) {
                isVisibleInEditor |= ((ISpecTestCasePO)editorNode).getAllEventEventExecTC().contains(po);
            }
            switch (dataState) {
                case Added: {
                    if (!isVisibleInEditor) break;
                    this.handleNodeAdded(changedNode);
                    break;
                }
                case Deleted: {
                    if (po instanceof IProjectPO) break;
                    this.refresh();
                    break;
                }
                case Renamed: {
                    this.createPartName();
                    break;
                }
                case StructureModified: {
                    if (isVisibleInEditor) {
                        this.getEditorHelper().setDirty(true);
                    }
                    if (this.handleStructureModified(po)) break;
                    return;
                }
                case ReuseChanged: {
                    break;
                }
                default: {
                    Assert.notReached();
                }
            }
            if (isVisibleInEditor) {
                this.runLocalChecks();
            }
            this.getEditorHelper().handleDataChanged(po, dataState);
        }
    }

    private boolean handleStructureModified(IPersistentObject po) {
        if (po instanceof ISpecTestCasePO) {
            ISpecTestCasePO specTestCasePO = (ISpecTestCasePO)po;
            INodePO workVersion = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
            List execTestCases = NodePM.getInternalExecTestCases((String)specTestCasePO.getGuid(), (long)specTestCasePO.getParentProjectId());
            if (!execTestCases.isEmpty() && AbstractTestCaseEditor.containsWorkVersionReuses(workVersion, specTestCasePO)) {
                if (Plugin.getActiveEditor() != this && this.isDirty()) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_SAVE_AND_REOPEN_EDITOR, (Object[])new Object[]{this.getTitle(), specTestCasePO.getName()}, null);
                    return false;
                }
                try {
                    this.reOpenEditor(this.getEditorHelper().getEditSupport().getOriginal());
                }
                catch (PMException pMException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_REFRESH_FAILED, null, (String[])new String[]{Messages.ErrorMessageEDITOR_CLOSE});
                    this.getSite().getPage().closeEditor((IEditorPart)this, false);
                }
                return false;
            }
        }
        return true;
    }

    private static boolean containsWorkVersionReuses(INodePO root, ISpecTestCasePO specTc) {
        Iterator it = root.getNodeListIterator();
        List childList = IteratorUtils.toList((Iterator)it);
        if (root instanceof ISpecTestCasePO) {
            ISpecTestCasePO rootSpecTc = (ISpecTestCasePO)root;
            childList.addAll(rootSpecTc.getAllEventEventExecTC());
        }
        for (INodePO child : childList) {
            if (!(child instanceof IExecTestCasePO)) continue;
            IExecTestCasePO execTc = (IExecTestCasePO)child;
            if (specTc.equals((Object)execTc.getSpecTestCase())) {
                return true;
            }
            if (!AbstractTestCaseEditor.containsWorkVersionReuses((INodePO)execTc, specTc)) continue;
            return true;
        }
        return false;
    }

    void setEventHandlerProperties(IEventExecTestCasePO eventHandler, String refName, String eventType, String reentryType, Integer maxRetries) {
        eventHandler.setName(refName);
        eventHandler.setEventType(eventType);
        ReentryProperty[] reentryProps = ReentryProperty.REENTRY_PROP_ARRAY;
        int i = 0;
        while (i < reentryProps.length) {
            if (String.valueOf(reentryProps[i]).equals(reentryType)) {
                eventHandler.setReentryProp(reentryProps[i]);
                break;
            }
            ++i;
        }
        Assert.verify((eventHandler.getReentryProp() != null ? 1 : 0) != 0, (String)(String.valueOf(Messages.ErrorWhenSettingReentryProperty) + "!"));
        eventHandler.setMaxRetries(maxRetries);
    }

    private void updateTDManagerOfExecTestCases(INodePO root) {
        Iterator it = root.getNodeListIterator();
        while (it.hasNext()) {
            IParamNodePO child = (IParamNodePO)it.next();
            if (!(child instanceof IExecTestCasePO)) continue;
            ((IExecTestCasePO)child).synchronizeParameterIDs();
        }
    }

    protected final void checkAndRemoveUnusedTestData() {
        EditSupport editSupport = this.getEditorHelper().getEditSupport();
        IPersistentObject workVersion = editSupport.getWorkVersion();
        if (!(workVersion instanceof INodePO)) {
            return;
        }
        INodePO nodePO = (INodePO)workVersion;
        List execsWithUnusedTestData = TestCaseParamBP.getExecTcWithUnusedTestData((INodePO)nodePO);
        if (execsWithUnusedTestData.isEmpty()) {
            return;
        }
        try {
            editSupport.lockWorkVersion();
            this.getEditorHelper().setDirty(true);
            this.updateTDManagerOfExecTestCases(nodePO);
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        catch (PMAlreadyLockedException pMAlreadyLockedException) {
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
    }

    protected IStructuredSelection getStructuredSelection() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private void handleNodeAdded(INodePO addedNode) {
        this.refresh();
        this.setSelection((ISelection)new StructuredSelection((Object)addedNode));
    }

    private class CentralTestDataUpdateListener
    implements DataEventDispatcher.IDataChangedListener {
        private CentralTestDataUpdateListener() {
        }

        public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
            if (po instanceof ITestDataCategoryPO && dataState == DataEventDispatcher.DataState.StructureModified && updateState != DataEventDispatcher.UpdateState.notInEditor) {
                AbstractNonPostOperatingTreeNodeOperation<INodePO> refreshRefDataCubeOp = new AbstractNonPostOperatingTreeNodeOperation<INodePO>(){

                    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
                        IParameterInterfacePO referencedCube;
                        if (node instanceof IParamNodePO && (referencedCube = ((IParamNodePO)node).getReferencedDataCube()) != null) {
                            AbstractTestCaseEditor.this.getEditorHelper().getEditSupport().getSession().refresh((Object)referencedCube);
                        }
                        return true;
                    }
                };
                TreeTraverser refDataCubeRefresher = new TreeTraverser((INodePO)AbstractTestCaseEditor.this.getEditorHelper().getEditSupport().getWorkVersion(), (ITreeNodeOperation)refreshRefDataCubeOp, true, 2);
                refDataCubeRefresher.traverse(true);
            }
        }

        public void handleDataChanged(DataChangedEvent ... events) {
            DataChangedEvent[] dataChangedEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DataChangedEvent e = dataChangedEventArray[n2];
                this.handleDataChanged(e.getPo(), e.getDataState(), e.getUpdateState());
                ++n2;
            }
        }
    }
}

