/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.commands.ChangeAUTModeCommand;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.listener.BaseAWTEventListener;
import org.eclipse.jubula.rc.swing.listener.IEventListener;
import org.eclipse.jubula.rc.swing.listener.KeyAcceptor;
import org.eclipse.jubula.rc.swing.tester.util.TesterUtil;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;

public abstract class AbstractAutSwingEventListener
extends BaseAWTEventListener
implements IEventListener,
AUTEventListener {
    protected static final int REPAINT_DELAY = 5;
    private static AutServerLogger log = new AutServerLogger(AbstractAutSwingEventListener.class);
    private static final long[] EVENT_MASK = new long[]{16L, 32L, 8L, 512L, 128L, 1024L, 4L, 1L, 64L, 524288L, 262144L};
    private Object m_componentLock = new Object();
    private Component m_currentComponent = null;
    private KeyAcceptor m_acceptor = new KeyAcceptor();
    private AWTEvent m_lastEvent;
    private boolean m_isHighLighted = false;

    public void eventDispatched(AWTEvent event) {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.handleEvent(event);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    protected abstract void handleEvent(AWTEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        Object object = this.m_componentLock;
        synchronized (object) {
            if (this.getCurrentComponent() != null) {
                try {
                    AUTServerConfiguration.getInstance().getImplementationClass(AbstractAutSwingEventListener.getComponentClass(this.getCurrentComponent()));
                    TesterUtil.lowLight(this.m_currentComponent);
                }
                catch (IllegalArgumentException iae) {
                    log.error((Object)iae);
                }
                catch (UnsupportedComponentException uce) {
                    log.warn((Object)uce);
                }
            }
        }
    }

    protected void changeCheckModeState(int mode) {
        ChangeAUTModeMessage msg = new ChangeAUTModeMessage();
        msg.setMode(mode);
        msg.setKey(AUTServerConfiguration.getInstance().getKey());
        msg.setKeyModifier(AUTServerConfiguration.getInstance().getKeyMod());
        msg.setKey2(AUTServerConfiguration.getInstance().getKey2());
        msg.setKey2Modifier(AUTServerConfiguration.getInstance().getKey2Mod());
        msg.setCheckModeKey(AUTServerConfiguration.getInstance().getCheckModeKey());
        msg.setCheckModeKeyModifier(AUTServerConfiguration.getInstance().getCheckModeKeyMod());
        msg.setCheckCompKey(AUTServerConfiguration.getInstance().getCheckCompKey());
        msg.setCheckCompKeyModifier(AUTServerConfiguration.getInstance().getCheckCompKeyMod());
        msg.setSingleLineTrigger(AUTServerConfiguration.getInstance().getSingleLineTrigger());
        msg.setMultiLineTrigger(AUTServerConfiguration.getInstance().getMultiLineTrigger());
        ChangeAUTModeCommand cmd = new ChangeAUTModeCommand();
        cmd.setMessage((Message)msg);
        try {
            Communicator clientCommunicator = AUTServer.getInstance().getCommunicator();
            if (clientCommunicator != null && clientCommunicator.getConnection() != null) {
                AUTServer.getInstance().getCommunicator().send(cmd.execute());
            }
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
    }

    public long[] getEventMask() {
        long[] eventMask = EVENT_MASK;
        return eventMask;
    }

    protected AWTEvent getLastEvent() {
        return this.m_lastEvent;
    }

    protected void setLastEvent(AWTEvent lastEvent) {
        this.m_lastEvent = lastEvent;
    }

    protected Object getComponentLock() {
        return this.m_componentLock;
    }

    protected Component getCurrentComponent() {
        return this.m_currentComponent;
    }

    protected void setCurrentComponent(Component currentComponent) {
        this.m_currentComponent = currentComponent;
    }

    protected KeyAcceptor getAcceptor() {
        return this.m_acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void highlight(Component source, Object implClass, Color highlightColor) {
        Object object = this.getComponentLock();
        synchronized (object) {
            if (this.getCurrentComponent() != null && this.getCurrentComponent() != source) {
                TesterUtil.lowLight(this.getCurrentComponent());
                this.setHighLighted(false);
            }
            this.setCurrentComponent(source);
            Window windowAncestor = SwingUtilities.getWindowAncestor(this.getCurrentComponent());
            if (windowAncestor != null && windowAncestor.getFocusOwner() != null) {
                try {
                    AUTServerConfiguration.getInstance().getImplementationClass(AbstractAutSwingEventListener.getComponentClass(this.getCurrentComponent()));
                    TesterUtil.highLight(this.getCurrentComponent(), highlightColor);
                    this.setHighLighted(true);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"unexpected exception", (Throwable)e);
                }
                catch (UnsupportedComponentException unsupportedComponentException) {}
            }
        }
    }

    protected void highlightClicked(Object implClass, final Color highlightColor) {
        Timer timer = new Timer(5, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Object object = AbstractAutSwingEventListener.this.getComponentLock();
                synchronized (object) {
                    if (AbstractAutSwingEventListener.this.getCurrentComponent() != null && AbstractAutSwingEventListener.this.getCurrentComponent().isShowing() && SwingUtilities.getWindowAncestor(AbstractAutSwingEventListener.this.getCurrentComponent()) != null && SwingUtilities.getWindowAncestor(AbstractAutSwingEventListener.this.getCurrentComponent()).getFocusOwner() != null) {
                        try {
                            AUTServerConfiguration.getInstance().getImplementationClass(AbstractAutSwingEventListener.getComponentClass(AbstractAutSwingEventListener.this.getCurrentComponent()));
                            TesterUtil.highLight(AbstractAutSwingEventListener.this.getCurrentComponent(), highlightColor);
                        }
                        catch (IllegalArgumentException iae) {
                            log.error((Object)"unexpected exception", (Throwable)iae);
                        }
                        catch (UnsupportedComponentException unsupportedComponentException) {}
                    }
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    protected void updateHighlighting(Component source, Object implClass, Color highlightColor) {
        if (this.isHighLighted()) {
            this.highlight(source, implClass, highlightColor);
        }
    }

    public boolean isHighLighted() {
        return this.m_isHighLighted;
    }

    protected void setHighLighted(boolean isHighLighted) {
        this.m_isHighLighted = isHighLighted;
    }
}

