/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the AlertPromptConfirmation component from the html toolkit.
 */
@TesterClass(testerClass="com.bredexsw.jubula.rc.html.web.implclasses.AlertImplClass")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-06-04T13:16:11.674Z")
public class AlertPromptConfirmation implements org.eclipse.jubula.toolkit.html.components.AlertPromptConfirmation {
            public AlertPromptConfirmation() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =
            new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();
        pseudoIdentifier.setComponentClassName("html.alert"); //$NON-NLS-1$
        return pseudoIdentifier;
    }
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkText(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistence(
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyExists"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP inputText(
            @NonNull String text
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcInputText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param type 
         *        the type of interaction
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP setInteractionType(
            @NonNull String type
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcInteract"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(type, "Argument 'type' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(type), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        @NonNull public CAP interact(
        )  {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCloseDialog"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            return messageCap;
        }
        
} 