/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.javafx.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the {@link javafx.scene.control.TreeTableView} component from the javafx toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-06-04T13:16:11.739Z")
public interface TreeTableView extends org.eclipse.jubula.toolkit.javafx.components.TreeView {
    
    
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectEntryByTextpathSpecifyColumn(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks,
            @NonNull Integer column,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectEntryByIndexpathSpecifyColumn(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath,
            @NonNull Integer numberOfClicks,
            @NonNull Integer column,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionByValueSSpecifyColumn(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull Integer column
        ) throws IllegalArgumentException;
        
} 