/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views;

import javax.persistence.EntityManager;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IEntityManagerProvider;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.rcp.controllers.AbstractPartListener;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.filter.JBBrowserPatternFilter;
import org.eclipse.jubula.client.ui.rcp.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.sorter.NodeNameViewerSorter;
import org.eclipse.jubula.client.ui.rcp.utils.UIIdentitiyElementComparer;
import org.eclipse.jubula.client.ui.rcp.views.JBPropertiesPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class AbstractJBTreeView
extends ViewPart
implements DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener,
IEntityManagerProvider {
    public static final int DEFAULT_EXPANSION = 2;
    protected static final int NUM_COLUMNS_1 = 1;
    protected static final int VERTICAL_SPACING = 3;
    private TreeViewer m_treeViewer;
    private Text m_treeFilterText;
    private Clipboard m_clipboard;
    private boolean m_isLinkedWithEditor = false;
    private PartListener m_partListener = new PartListener();

    private void setSelectionToEditorNode(IWorkbenchPart part) {
        if (part != null) {
            IPersistentObject editorWorkVersion;
            Object obj = part.getAdapter(AbstractTestCaseEditor.class);
            AbstractTestCaseEditor tce = (AbstractTestCaseEditor)obj;
            if (obj != null && this.m_isLinkedWithEditor && tce != null && (editorWorkVersion = tce.getEditorHelper().getEditSupport().getWorkVersion()) != null) {
                UINodeBP.selectNodeInTree(editorWorkVersion.getId(), this.getTreeViewer(), this.getEntityManager());
            }
        }
    }

    protected abstract void rebuildTree();

    public Object getAdapter(Class adapter) {
        if (adapter.equals(AbstractJBTreeView.class)) {
            return this;
        }
        if (adapter.equals(IPropertySheetPage.class)) {
            return new JBPropertiesPage(false, null);
        }
        return super.getAdapter(adapter);
    }

    public final void handleProjectLoaded() {
        if (GeneralStorage.getInstance().getProject() == null) {
            return;
        }
        Plugin.startLongRunning();
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractJBTreeView.this.rebuildTree();
                }
                catch (OperationCanceledException operationCanceledException) {
                    AbstractJBTreeView.this.getTreeViewer().setInput(null);
                }
            }
        });
        Plugin.stopLongRunning();
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public ISelection getSelection() {
        return this.m_treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.m_treeViewer.setSelection(selection, true);
    }

    public void setTreeViewer(TreeViewer treeViewer) {
        this.m_treeViewer = treeViewer;
    }

    public void createPartControl(Composite parent) {
        this.m_clipboard = new Clipboard(parent.getDisplay());
        JBFilteredTree ft = new JBFilteredTree(parent, 2818, (PatternFilter)new JBBrowserPatternFilter(), true);
        this.setTreeViewer(ft.getViewer());
        this.setTreeFilterText(ft.getFilterControl());
        this.addTreeListener();
        this.getTreeViewer().setUseHashlookup(true);
        this.getTreeViewer().setSorter((ViewerSorter)new NodeNameViewerSorter());
        this.getTreeViewer().setComparer((IElementComparer)new UIIdentitiyElementComparer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
        this.getTreeViewer().setAutoExpandLevel(2);
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, false);
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new ToggleLinkingAction());
        this.getViewSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.m_partListener);
        this.setFocus();
        this.registerContextMenu();
    }

    protected void registerContextMenu() {
        MenuManager contextMenu = new MenuManager();
        this.createContextMenu((IMenuManager)contextMenu);
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        Control control = this.getTreeViewer().getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.getTreeViewer());
    }

    protected abstract void createContextMenu(IMenuManager var1);

    protected abstract void addTreeListener();

    public void dispose() {
        try {
            this.m_clipboard.dispose();
            this.getViewSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.m_partListener);
            DataEventDispatcher dispatcher = DataEventDispatcher.getInstance();
            dispatcher.firePartClosed((IWorkbenchPart)this);
            dispatcher.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        }
        finally {
            this.getTreeViewer().getTree().dispose();
            this.getSite().setSelectionProvider(null);
            super.dispose();
        }
    }

    public Clipboard getClipboard() {
        return this.m_clipboard;
    }

    public void setTreeFilterText(Text treeFilterText) {
        this.m_treeFilterText = treeFilterText;
    }

    public Text getTreeFilterText() {
        return this.m_treeFilterText;
    }

    public EntityManager getEntityManager() {
        GeneralStorage gs = GeneralStorage.getInstance();
        if (gs != null) {
            return gs.getEntityManager();
        }
        return null;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent previousEvent = null;
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            DataEventDispatcher.DataState dataState = e.getDataState();
            if (previousEvent == null || previousEvent.getDataState() != dataState || dataState != DataEventDispatcher.DataState.StructureModified && dataState != DataEventDispatcher.DataState.Deleted) {
                this.handleDataChanged(e.getPo(), dataState, e.getUpdateState());
                previousEvent = e;
            }
            ++n2;
        }
    }

    protected abstract void handleDataChanged(IPersistentObject var1, DataEventDispatcher.DataState var2, DataEventDispatcher.UpdateState var3);

    private final class PartListener
    extends AbstractPartListener {
        private PartListener() {
        }

        @Override
        public void partActivated(IWorkbenchPart part) {
            AbstractJBTreeView.this.setSelectionToEditorNode(part);
            super.partActivated(part);
        }
    }

    private final class ToggleLinkingAction
    extends Action {
        public ToggleLinkingAction() {
            super(Messages.TestCaseBrowserLinkWithEditor, 2);
            this.setImageDescriptor(IconConstants.LINK_WITH_EDITOR_DESCRIPTOR);
            AbstractJBTreeView.this.m_isLinkedWithEditor = Plugin.getDefault().getPreferenceStore().getBoolean("LINK_WITH_EDITOR_TCVIEW_KEY");
            this.setChecked(AbstractJBTreeView.this.m_isLinkedWithEditor);
        }

        public void run() {
            AbstractJBTreeView.this.m_isLinkedWithEditor = this.isChecked();
            Plugin.getDefault().getPreferenceStore().setValue("LINK_WITH_EDITOR_TCVIEW_KEY", AbstractJBTreeView.this.m_isLinkedWithEditor);
            if (Plugin.getActiveEditor() instanceof AbstractTestCaseEditor && AbstractJBTreeView.this.m_isLinkedWithEditor) {
                AbstractJBTreeView.this.setSelectionToEditorNode((IWorkbenchPart)Plugin.getActiveEditor());
            }
        }
    }
}

