/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.stage.Stage;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.components.AUTComponent;
import org.eclipse.jubula.rc.common.components.AUTHierarchy;
import org.eclipse.jubula.rc.common.components.HierarchyContainer;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.javafx.components.ChildrenGetter;
import org.eclipse.jubula.rc.javafx.components.CurrentStages;
import org.eclipse.jubula.rc.javafx.components.FindJavaFXComponentBP;
import org.eclipse.jubula.rc.javafx.components.JavaFXComponent;
import org.eclipse.jubula.rc.javafx.components.JavaFXHierarchyContainer;
import org.eclipse.jubula.rc.javafx.components.ParentGetter;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public class AUTJavaFXHierarchy
extends AUTHierarchy<EventTarget> {
    private static AutServerLogger log = new AutServerLogger(AUTJavaFXHierarchy.class);
    private static FindJavaFXComponentBP findBP = new FindJavaFXComponentBP();
    private static volatile ReentrantLock lock = new ReentrantLock(true);

    public void createHierarchyFrom(EventTarget eventTarget) {
        lock.lock();
        try {
            EventTarget parent;
            Map realMap = this.getRealMap();
            EventTarget lastParent = parent = ParentGetter.get(eventTarget);
            while (parent != null) {
                if (realMap.containsKey(parent)) {
                    lastParent = parent;
                    break;
                }
                lastParent = parent;
                parent = ParentGetter.get(parent);
            }
            this.createHierarchy(lastParent == null ? eventTarget : lastParent);
        }
        finally {
            lock.unlock();
        }
    }

    private void createHierarchy(EventTarget parent) {
        JavaFXHierarchyContainer parentCont;
        if (parent == null) {
            return;
        }
        if (this.getRealMap().containsKey(parent)) {
            parentCont = this.getHierarchyContainer(parent);
        } else {
            parentCont = this.initContainer(parent);
            this.name(parentCont);
            this.addToHierachyMap(parentCont);
        }
        List<EventTarget> children = ChildrenGetter.getAsList(parent);
        for (EventTarget child : children) {
            this.createHierarchy(child);
            JavaFXHierarchyContainer childCont = this.getHierarchyContainer(child);
            if (!parentCont.contains(childCont)) {
                parentCont.add(childCont);
                childCont.setPrnt(parentCont);
            } else if (childCont.getPrnt() == null) {
                childCont.setPrnt(parentCont);
            }
            this.name(childCont);
        }
    }

    private JavaFXHierarchyContainer initContainer(EventTarget node) {
        JavaFXComponent comp = new JavaFXComponent(node);
        JavaFXHierarchyContainer cont = new JavaFXHierarchyContainer(comp);
        return cont;
    }

    public void removeComponentFromHierarchy(EventTarget component) {
        JavaFXHierarchyContainer cont;
        if (component != null && (cont = this.getHierarchyContainer(component)) != null) {
            this.removeContainer(cont);
        }
    }

    public void removeContainer(HierarchyContainer<EventTarget> container) {
        lock.lock();
        try {
            HierarchyContainer[] children;
            Map contMap = this.getHierarchyMap();
            Map realMap = this.getRealMap();
            JavaFXComponent fxComp = (JavaFXComponent)container.getCompID();
            fxComp.removeChangeListener();
            contMap.remove(container.getCompID());
            realMap.remove(fxComp.getComponent());
            HierarchyContainer parent = container.getPrnt();
            if (parent != null) {
                parent.remove(container);
            }
            HierarchyContainer[] hierarchyContainerArray = children = container.getComps();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                HierarchyContainer child = hierarchyContainerArray[n2];
                this.removeContainer((HierarchyContainer<EventTarget>)child);
                ++n2;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public IComponentIdentifier[] getAllComponentId() {
        Vector<IComponentIdentifier> result = new Vector<IComponentIdentifier>();
        Set keys = this.getHierarchyMap().keySet();
        for (AUTComponent wrapComp : keys) {
            EventTarget comp = (EventTarget)wrapComp.getComponent();
            try {
                if (!AUTServerConfiguration.getInstance().isSupported((Object)comp)) continue;
                result.add(this.getComponentIdentifier(comp));
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)"hierarchy map contains null values", (Throwable)iae);
            }
            catch (ComponentNotManagedException e) {
                log.error((Object)("component '" + comp.getClass().getName() + "' not found!"), (Throwable)e);
            }
        }
        return result.toArray(new IComponentIdentifier[result.size()]);
    }

    public IComponentIdentifier getComponentIdentifier(EventTarget component) throws ComponentNotManagedException {
        ComponentIdentifier result = new ComponentIdentifier();
        try {
            result.setComponentClassName(component.getClass().getName());
            result.setSupportedClassName(AUTServerConfiguration.getInstance().getTestableClass(component.getClass()).getName());
            List<String> hierarchy = this.getPathToRoot(component);
            result.setHierarchyNames(hierarchy);
            result.setNeighbours(this.getComponentContext(component));
            JavaFXHierarchyContainer cont = this.getHierarchyContainer(component);
            this.setAlternativeDisplayName(cont, component, (IComponentIdentifier)result);
            if (component.equals(findBP.findComponent((IComponentIdentifier)result, ComponentHandler.getAutHierarchy()))) {
                result.setEqualOriginalFound(true);
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            log.error((Object)iae);
            throw new ComponentNotManagedException("getComponentIdentifier() called for an unmanaged component: " + component, MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
    }

    public Object findComponent(IComponentIdentifier componentIdentifier) throws IllegalArgumentException, ComponentNotManagedException, InvalidDataException {
        Object comp = findBP.findComponent(componentIdentifier, ComponentHandler.getAutHierarchy());
        if (comp != null) {
            return comp;
        }
        throw new ComponentNotManagedException("unmanaged component with identifier: '" + componentIdentifier.toString() + "'.", MessageIDs.E_COMPONENT_NOT_MANAGED);
    }

    public List<String> getPathToRoot(EventTarget component) throws IllegalArgumentException, ComponentNotManagedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("pathToRoot called for " + component));
        }
        Validate.notNull((Object)component, (String)"The component must not be null");
        ArrayList<String> hierarchy = new ArrayList<String>();
        JavaFXHierarchyContainer container = this.getHierarchyContainer(component);
        hierarchy.add(container.getName());
        JavaFXHierarchyContainer parent = (JavaFXHierarchyContainer)container.getPrnt();
        while (parent != null) {
            container = parent;
            hierarchy.add(0, container.getName());
            parent = (JavaFXHierarchyContainer)container.getPrnt();
        }
        return hierarchy;
    }

    protected List<String> getComponentContext(EventTarget component) {
        ArrayList<String> context = new ArrayList<String>();
        JavaFXHierarchyContainer comp = component instanceof JavaFXHierarchyContainer ? (JavaFXHierarchyContainer)component : this.getHierarchyContainer(component);
        JavaFXHierarchyContainer parent = (JavaFXHierarchyContainer)comp.getPrnt();
        if (parent != null) {
            HierarchyContainer[] comps;
            HierarchyContainer[] hierarchyContainerArray = comps = parent.getComps();
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                HierarchyContainer child = hierarchyContainerArray[n2];
                if (!child.equals((Object)comp)) {
                    String toAdd = child.getName();
                    context.add(toAdd);
                }
                ++n2;
            }
        }
        return context;
    }

    public JavaFXHierarchyContainer getHierarchyContainer(EventTarget component) throws IllegalArgumentException {
        Validate.notNull((Object)component, (String)"The component must not be null");
        JavaFXHierarchyContainer result = null;
        try {
            AUTComponent compID = (AUTComponent)this.getRealMap().get(component);
            if (compID != null) {
                result = (JavaFXHierarchyContainer)((Object)this.getHierarchyMap().get(compID));
            }
        }
        catch (ClassCastException cce) {
            log.error((Object)cce);
        }
        catch (NullPointerException npe) {
            log.error((Object)npe);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected void name(JavaFXHierarchyContainer hierarchyContainer) {
        block9: {
            comp = hierarchyContainer.getCompID();
            realComponent = (EventTarget)comp.getComponent();
            compName = realComponent instanceof Node != false ? ((Node)realComponent).getId() : (realComponent instanceof MenuItem != false ? ((MenuItem)realComponent).getId() : null);
            if (realComponent instanceof Stage) {
                stages = CurrentStages.getStageList();
                names = new ArrayList<String>();
                for (Stage stage : stages) {
                    c = this.getHierarchyContainer((EventTarget)stage);
                    if (c == null || c == hierarchyContainer) continue;
                    names.add(c.getName());
                }
                name = null;
                count = 0;
                while (!this.isUniqueName(name, names)) {
                    name = this.createName(realComponent, ++count);
                }
                comp.setName(name);
                hierarchyContainer.setName(name, true);
                return;
            }
            hierParent = hierarchyContainer.getPrnt();
            if (hierarchyContainer.getName() != null && hierarchyContainer.getName().length() != 0 && !hierarchyContainer.getName().trim().isEmpty()) {
                if (this.isUniqueName((HierarchyContainer<EventTarget>)hierParent, hierarchyContainer.getName(), hierarchyContainer)) {
                    return;
                }
                if (AUTJavaFXHierarchy.log.isInfoEnabled()) {
                    AUTJavaFXHierarchy.log.info((Object)("New name created for " + hierarchyContainer.getName() + "even though there was already a name!"));
                }
            }
            count = 0;
            originalName = null;
            newName = null;
            v0 = newNameGenerated = compName == null;
            if (!StringUtils.isBlank((String)compName)) {
                originalName = compName;
                newName = compName;
            }
            if (newName != null) ** GOTO lbl40
            while (!this.isUniqueName((HierarchyContainer<EventTarget>)hierParent, newName, hierarchyContainer)) {
                newName = this.createName(realComponent, ++count);
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                newName = this.createName(originalName, ++count);
lbl40:
                // 2 sources

                ** while (!this.isUniqueName((HierarchyContainer<EventTarget>)hierParent, (String)newName, (HierarchyContainer<EventTarget>)hierarchyContainer))
            }
        }
        comp.setName(newName);
        hierarchyContainer.setName(newName, newNameGenerated);
    }

    protected boolean isUniqueName(HierarchyContainer<EventTarget> parent, String name, HierarchyContainer<EventTarget> container) {
        HierarchyContainer[] compIDs;
        if (name == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        HierarchyContainer[] hierarchyContainerArray = compIDs = parent.getComps();
        int n = compIDs.length;
        int n2 = 0;
        while (n2 < n) {
            HierarchyContainer childContainer = hierarchyContainerArray[n2];
            String childName = childContainer.getName();
            if (name.equals(childName) && childContainer != container) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isUniqueName(String name, List<String> otherNames) {
        if (name == null || otherNames == null) {
            return false;
        }
        if (otherNames.isEmpty()) {
            return true;
        }
        return !otherNames.contains(name);
    }

    public static ReentrantLock getLock() {
        return lock;
    }
}

