/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.ServerShowDialogMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.commands.ShowDialogResultCommand;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.swing.listener.AbstractAutSwingEventListener;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.listener.RecordHelper;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.utils.StringParsing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckListener
extends AbstractAutSwingEventListener {
    private static AutServerLogger log = new AutServerLogger(CheckListener.class);
    private boolean m_active = true;
    private RecordHelper m_recordHelper = new RecordHelper();

    @Override
    protected void handleEvent(AWTEvent event) {
        if (event.equals(this.getLastEvent())) {
            return;
        }
        if (this.getEventSource(event) == null) {
            return;
        }
        this.setLastEvent(event);
        Component source = this.getEventSource(event);
        Container parent = source.getParent();
        Object implClass = null;
        if (event instanceof KeyEvent && source instanceof JComponent) {
            KeyEvent keyEvent = (KeyEvent)event;
            this.handleKeyEvent(keyEvent);
        } else {
            if (parent != null) {
                try {
                    implClass = AUTServerConfiguration.getInstance().getImplementationClass(parent.getClass());
                    source = parent;
                }
                catch (UnsupportedComponentException unsupportedComponentException) {}
            }
            if (implClass == null) {
                try {
                    implClass = AUTServerConfiguration.getInstance().getImplementationClass(source.getClass());
                }
                catch (UnsupportedComponentException unsupportedComponentException) {
                    return;
                }
            }
            if (event instanceof MouseEvent && source instanceof JComponent) {
                this.switchEvent(event, source, implClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyEvent(KeyEvent keyEvent) {
        Object object = this.getComponentLock();
        synchronized (object) {
            if (keyEvent.getID() == 401) {
                IComponentIdentifier id = null;
                int accepted = this.getAcceptor().accept(keyEvent);
                if (accepted == 2) {
                    this.changeCheckModeState(3);
                    this.cleanUp();
                }
                if (accepted == 3) {
                    try {
                        id = this.getCurrentComponent() instanceof JMenuItem ? this.m_recordHelper.getMenuCompID() : ComponentHandler.getIdentifier(this.getCurrentComponent());
                        Map<String, String> checkValues = this.getCheckValues(this.getCurrentComponent());
                        String logName = this.m_recordHelper.generateLogicalName(this.getCurrentComponent(), id);
                        this.openCheckDialog(id, checkValues, logName);
                    }
                    catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                        log.error((Object)("no identifier for '" + this.getCurrentComponent()));
                    }
                }
            }
        }
    }

    protected void openCheckDialog(IComponentIdentifier id, Map<String, String> checkValues, String logName) {
        try {
            AUTServer.getInstance().setMode(1);
            this.m_active = true;
            org.eclipse.jubula.tools.internal.xml.businessmodell.Component comp = AUTServerConfiguration.getInstance().findComponent(id.getSupportedClassName());
            this.sendMessage(id, comp, checkValues, logName);
            AUTServer.getInstance().setObservingDialogOpen(true);
            if (this.m_active) {
                AUTServer.getInstance().setMode(4);
            }
        }
        catch (CommunicationException nifce) {
            AUTServer.getInstance().setObservingDialogOpen(false);
            log.error((Object)("communication exception: '" + (Object)((Object)nifce)));
        }
    }

    protected Map<String, String> addFocExistEnbl(Map<String, String> valueMap, String hasFocus, String exists, String enabled) {
        valueMap.put("CompSystem.HasFocus", hasFocus);
        valueMap.put("CompSystem.IsExisting", exists);
        valueMap.put("CompSystem.IsEnabled", enabled);
        return valueMap;
    }

    protected Map<String, String> getCheckValues(Component component) {
        Map<Object, Object> valueMap = new HashMap();
        if (component instanceof JTextComponent) {
            valueMap = this.getTextCompValues(component);
        }
        if (component instanceof AbstractButton) {
            valueMap = this.getButtonValues(component);
        }
        if (component instanceof JLabel) {
            valueMap = this.getLabelValues(component);
        }
        if (component instanceof JTree) {
            valueMap = this.getTreeValues(component);
        }
        if (component instanceof JList) {
            valueMap = this.getListValues(component);
        }
        if (component instanceof JComboBox) {
            valueMap = this.getComboValues(component);
        }
        if (component instanceof JTabbedPane) {
            valueMap = this.getTpnValues(component);
        }
        if (component instanceof JTable) {
            valueMap = this.getTableValues(component);
        }
        if (component instanceof JMenuItem) {
            valueMap = this.getMenuItemValues(component);
        }
        return valueMap;
    }

    private Map<String, String> getTextCompValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        JTextComponent t = (JTextComponent)c;
        String text = StringParsing.singleQuoteText((String)t.getText());
        map.put("CompSystem.Text", text);
        String hasFocus = StringParsing.boolToString((boolean)t.hasFocus());
        String exists = StringParsing.boolToString((boolean)t.isShowing());
        String enabled = StringParsing.boolToString((boolean)t.isEnabled());
        String editable = StringParsing.boolToString((boolean)t.isEditable());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        map.put("CompSystem.IsEditable", editable);
        return map;
    }

    private Map<String, String> getButtonValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        AbstractButton ab = (AbstractButton)c;
        String text = StringParsing.singleQuoteText((String)ab.getText());
        String hasFocus = StringParsing.boolToString((boolean)ab.hasFocus());
        String exists = StringParsing.boolToString((boolean)ab.isShowing());
        String enabled = StringParsing.boolToString((boolean)ab.isEnabled());
        String selected = StringParsing.boolToString((boolean)ab.isSelected());
        map.put("CompSystem.Text", text);
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        map.put("CompSystem.IsSelected", selected);
        return map;
    }

    private Map<String, String> getLabelValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        JLabel lbl = (JLabel)c;
        String text = StringParsing.singleQuoteText((String)lbl.getText());
        String hasFocus = StringParsing.boolToString((boolean)lbl.hasFocus());
        String exists = StringParsing.boolToString((boolean)lbl.isShowing());
        String enabled = StringParsing.boolToString((boolean)lbl.isEnabled());
        map.put("CompSystem.Text", text);
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    private Map<String, String> getTreeValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        JTree tre = (JTree)c;
        if (tre.getSelectionCount() != 0) {
            TreePath[] selNodes = tre.getSelectionPaths();
            String treText = "";
            int i = 0;
            while (i < selNodes.length) {
                Object value = selNodes[i].getLastPathComponent();
                String node = StringParsing.maskAndSingleQuoteText((String)this.m_recordHelper.getRenderedTreeNodeText(tre, value), (int)2);
                treText = treText.concat(node);
                if (i < selNodes.length - 1) {
                    treText = treText.concat(",");
                }
                ++i;
            }
            TreePath tp = tre.getSelectionPath();
            String textpath = this.m_recordHelper.treepathToTextpath(tre, tp);
            String existNode = "true";
            map.put("CompSystem.Text", treText);
            map.put("CompSystem.TextPath", textpath);
            map.put("CompSystem.Exists", existNode);
        }
        String preascend = "0";
        String hasFocus = StringParsing.boolToString((boolean)tre.hasFocus());
        String exists = StringParsing.boolToString((boolean)tre.isShowing());
        String enabled = StringParsing.boolToString((boolean)tre.isEnabled());
        map.put("CompSystem.PreAscend", preascend);
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    private Map<String, String> getListValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        JList lst = (JList)c;
        if (lst.getSelectedIndices().length != 0) {
            String[] entries = this.m_recordHelper.getRenderedListValues(lst);
            String lstText = "";
            int i = 0;
            while (i < entries.length) {
                String item = StringParsing.maskAndSingleQuoteText((String)entries[i], (int)1);
                lstText = lstText.concat(item);
                if (i < entries.length - 1) {
                    lstText = lstText.concat(",");
                }
                ++i;
            }
            String isSel = StringParsing.boolToString((boolean)lst.isSelectedIndex(lst.getSelectedIndex()));
            map.put("CompSystem.IsSelected", isSel);
            map.put("CompSystem.Text", lstText);
            map.put("CompSystem.Exists", "true");
        }
        String hasFocus = StringParsing.boolToString((boolean)lst.hasFocus());
        String exists = StringParsing.boolToString((boolean)lst.isShowing());
        String enabled = StringParsing.boolToString((boolean)lst.isEnabled());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    private Map<String, String> getComboValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        JComboBox cbx = (JComboBox)c;
        String cbxText = "";
        boolean isCbxItem = true;
        if (cbx.isEditable()) {
            isCbxItem = false;
            ComboBoxEditor cbxEditor = cbx.getEditor();
            cbxText = cbxEditor.getItem().toString();
            String[] cbxItems = this.m_recordHelper.getRenderedComboItems(cbx);
            int i = 0;
            while (i < cbxItems.length) {
                String item = cbxItems[i];
                if (item.equals(cbxText)) {
                    isCbxItem = true;
                }
                ++i;
            }
            String isComboItem = StringParsing.boolToString((boolean)isCbxItem);
            map.put("CompSystem.Text", cbxText);
            map.put("CompSystem.Exists", isComboItem);
        } else if (cbx.getSelectedItem() != null && isCbxItem) {
            cbxText = StringParsing.singleQuoteText((String)this.m_recordHelper.getRenderedComboText(cbx));
            map.put("CompSystem.Text", cbxText);
            map.put("CompSystem.Exists", "true");
        }
        String hasFocus = StringParsing.boolToString((boolean)cbx.hasFocus());
        String exists = StringParsing.boolToString((boolean)cbx.isShowing());
        String enabled = StringParsing.boolToString((boolean)cbx.isEnabled());
        String editable = StringParsing.boolToString((boolean)cbx.isEditable());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        map.put("CompSystem.IsEditable", editable);
        return map;
    }

    private Map<String, String> getTpnValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        JTabbedPane tp = (JTabbedPane)c;
        String hasFocus = StringParsing.boolToString((boolean)tp.hasFocus());
        String exists = StringParsing.boolToString((boolean)tp.isShowing());
        String enabled = StringParsing.boolToString((boolean)tp.isEnabled());
        String title = StringParsing.singleQuoteText((String)tp.getTitleAt(tp.getSelectedIndex()));
        String enabledTab = StringParsing.boolToString((boolean)tp.isEnabledAt(tp.indexOfTab(tp.getTitleAt(tp.getSelectedIndex()))));
        String isSel = "true";
        map.put("CompSystem.IsSelected", isSel);
        map.put("CompSystem.Title", title);
        map.put("CompSystem.Tab", title);
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        map.put("CompSystem.VerifyEnabledTab", enabledTab);
        return map;
    }

    private Map<String, String> getTableValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        JTable tbl = (JTable)c;
        int row = tbl.getSelectedRow();
        int column = tbl.getSelectedColumn();
        if (tbl.getSelectedColumnCount() != 0) {
            String tblText = StringParsing.singleQuoteText((String)this.m_recordHelper.getRenderedTableCellText(tbl, row, column));
            String rowStr = new Integer(row + 1).toString();
            String columnStr = new Integer(column + 1).toString();
            map.put("CompSystem.Text", tblText);
            map.put("CompSystem.TextOperator", MatchUtil.EQUALS);
            map.put("CompSystem.CellValue", tblText);
            map.put("CompSystem.ValueOperator", MatchUtil.EQUALS);
            map.put("CompSystem.Row", rowStr);
            map.put("CompSystem.RowOperator", MatchUtil.EQUALS);
            map.put("CompSystem.Column", columnStr);
            map.put("CompSystem.ColumnOperator", MatchUtil.EQUALS);
        }
        String hasFocus = StringParsing.boolToString((boolean)tbl.hasFocus());
        String exists = StringParsing.boolToString((boolean)tbl.isShowing());
        String enabled = StringParsing.boolToString((boolean)tbl.isEnabled());
        String cellEditable = StringParsing.boolToString((boolean)tbl.isCellEditable(row, column));
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        map.put("CompSystem.IsEditable", cellEditable);
        return map;
    }

    private Map<String, String> getMenuItemValues(Component c) {
        HashMap<String, String> map = new HashMap<String, String>();
        JMenuItem m = (JMenuItem)c;
        String menupath = this.m_recordHelper.getPath(m);
        map.put("CompSystem.MenuPath", menupath);
        String exists = StringParsing.boolToString((boolean)m.isShowing());
        String enabled = StringParsing.boolToString((boolean)m.isEnabled());
        String selected = StringParsing.boolToString((boolean)m.isSelected());
        map.put("CompSystem.IsExisting", exists);
        map.put("CompSystem.IsEnabled", enabled);
        map.put("CompSystem.IsSelected", selected);
        return map;
    }

    private void sendMessage(IComponentIdentifier id, org.eclipse.jubula.tools.internal.xml.businessmodell.Component comp, Map<String, String> checkValues, String logName) throws CommunicationException {
        ServerShowDialogMessage message = new ServerShowDialogMessage(comp, id, checkValues);
        message.setAction(3);
        message.setPoint(this.getCurrentComponent().getLocationOnScreen());
        message.setLogicalName(logName);
        ShowDialogResultCommand command = new ShowDialogResultCommand();
        AUTServer.getInstance().getServerCommunicator().request((Message)message, (ICommand)command, 6000);
    }

    protected void switchEvent(AWTEvent event, Component source, Object implClass) {
        Color highlightColor = new Color(200, 0, 0);
        switch (event.getID()) {
            case 501: 
            case 502: {
                this.highlightClicked(implClass, highlightColor);
                break;
            }
            case 503: 
            case 504: {
                this.highlight(source, implClass, highlightColor);
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("event occured: " + event.paramString()));
            }
        }
        int eventId = event.getID();
        if (eventId >= 100 && eventId <= 103 || eventId >= 800 && eventId <= 801 || eventId >= 200 && eventId <= 209) {
            this.updateHighlighting(source, implClass, highlightColor);
        }
    }

    public void update() {
    }

    public boolean highlightComponent(IComponentIdentifier comp) {
        return true;
    }
}

