/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the {@link org.eclipse.swt.widgets.ToolItem} component from the swt toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2016-02-04T15:41:37.174Z")
public interface ToolItem extends org.eclipse.jubula.toolkit.swt.components.Item {
    
    
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectMenuEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectMenuEntryByIndexpath(
            @NonNull String indexpath
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEnablementOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean enabled
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEnablementOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean enabled
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean selected
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean selected
        ) throws IllegalArgumentException;
        
} 