/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.AbstractEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;

public class TSEditorDndSupport
extends AbstractEditorDndSupport {
    private TSEditorDndSupport() {
    }

    public static boolean performDrop(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        return TCEditorDndSupport.performDrop(targetEditor, toDrop, dropTarget, dropPosition);
    }

    public static boolean copyPaste(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        ITestSuitePO targetNode = dropTarget instanceof ITestSuitePO ? (ITestSuitePO)dropTarget : (ITestSuitePO)dropTarget.getParentNode();
        int position = targetNode.indexOf(dropTarget);
        boolean needRefParamMessage = true;
        boolean needPropCompNameMessage = true;
        Object[] objectArray = selectedElements.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean modifyPropCompName;
            Object obj = objectArray[n2];
            ++position;
            if (!(obj instanceof IExecTestCasePO)) {
                return false;
            }
            IExecTestCasePO etc = (IExecTestCasePO)obj;
            boolean hasRefParam = etc.getParamReferencesIterator().hasNext();
            if (needRefParamMessage && hasRefParam) {
                MessageDialog.openInformation(null, (String)Messages.NotUseReferenceParameterTitle, (String)Messages.NotUseReferenceParameter);
                needRefParamMessage = false;
            }
            boolean bl = modifyPropCompName = !TSEditorDndSupport.checkCompName((IParamNodePO)obj, false);
            if (needPropCompNameMessage && modifyPropCompName) {
                MessageDialog.openInformation(null, (String)Messages.NotUsePropagatedComponentNameTitle, (String)Messages.NotUsePropagatedComponentName);
                needPropCompNameMessage = false;
            }
            TSEditorDndSupport.copyPasteExecTestCase(targetEditor, etc, targetNode, position, hasRefParam, modifyPropCompName);
            ++n2;
        }
        return true;
    }

    private static boolean checkCompName(IParamNodePO paramNodePO, boolean modifiy) {
        if (paramNodePO instanceof IExecTestCasePO) {
            for (ICompNamesPairPO origPair : ((IExecTestCasePO)paramNodePO).getCompNamesPairs()) {
                if (!origPair.isPropagated()) continue;
                if (modifiy) {
                    origPair.setPropagated(false);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean copyPasteExecTestCase(AbstractTestCaseEditor targetEditor, IExecTestCasePO execTestCase, ITestSuitePO targetNode, int dropPosition, boolean modifyRefParam, boolean modifyPropCompName) {
        IExecTestCasePO newExecTestCase = NodeMaker.createExecTestCasePO((ISpecTestCasePO)execTestCase.getSpecTestCase());
        TSEditorDndSupport.fillExec(execTestCase, newExecTestCase, true);
        if (modifyPropCompName) {
            TSEditorDndSupport.checkCompName((IParamNodePO)newExecTestCase, true);
        }
        TestCaseBP.addReferencedTestCase((INodePO)targetNode, (IExecTestCasePO)newExecTestCase, (Integer)dropPosition);
        targetEditor.getEditorHelper().setDirty(true);
        TSEditorDndSupport.postDropAction((INodePO)newExecTestCase, targetEditor);
        return true;
    }

    public static boolean validateCopy(IStructuredSelection toDrop, INodePO target) {
        return TSEditorDndSupport.validateCopy(toDrop, target, IExecTestCasePO.class, IEventExecTestCasePO.class);
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection selection, Object target, boolean allowFromBrowser) {
        if (selection == null || target == null) {
            return false;
        }
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            boolean foundOne = false;
            for (TestCaseBrowser tcb : MultipleTCBTracker.getInstance().getOpenTCBs()) {
                if (!sourceViewer.equals(tcb.getTreeViewer())) continue;
                foundOne = true;
            }
            if (!allowFromBrowser || !foundOne) {
                return false;
            }
        }
        for (Object transferObj : selection) {
            if (!(transferObj instanceof INodePO)) {
                return false;
            }
            INodePO transferGUI = (INodePO)transferObj;
            if (transferGUI instanceof IExecTestCasePO && sourceViewer == targetViewer || transferGUI instanceof ICommentPO && sourceViewer == targetViewer || transferGUI instanceof ISpecTestCasePO) continue;
            return false;
        }
        return true;
    }
}

