/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.examples.extension.javafx.test;

import org.eclipse.jubula.client.AUT;
import org.eclipse.jubula.client.AUTAgent;
import org.eclipse.jubula.client.MakeR;
import org.eclipse.jubula.client.exceptions.CheckFailedException;
import org.eclipse.jubula.client.launch.AUTConfiguration;
import org.eclipse.jubula.examples.extension.javafx.PieChartComponents;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.base.components.GraphicsComponent;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.toolkit.javafx.JavafxComponents;
import org.eclipse.jubula.toolkit.javafx.JavafxToolkit;
import org.eclipse.jubula.toolkit.javafx.config.JavaFXAUTConfiguration;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PieChartTest {
    public static final int DEFAULT_NO_OF_SLICES = 5;
    public static final String AGENT_HOST = "localhost";
    public static final int AGENT_PORT = 60000;
    private AUTAgent m_agent;
    private AUT m_aut;
    private PieChartComponents m_pcc;
    private static final ComponentIdentifier<?> pieChartIdentifier = MakeR.createCI((String)"rO0ABXNyAD1vcmcuZWNsaXBzZS5qdWJ1bGEudG9vbHMuaW50ZXJuYWwub2JqZWN0cy5Db21wb25lbnRJZGVudGlmaWVyAAAAAAAABAcCAAlaABRtX2VxdWFsT3JpZ2luYWxGb3VuZEQAEW1fbWF0Y2hQZXJjZW50YWdlSQAhbV9udW1iZXJPZk90aGVyTWF0Y2hpbmdDb21wb25lbnRzTAAYbV9hbHRlcm5hdGl2ZURpc3BsYXlOYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7TAAUbV9jb21wb25lbnRDbGFzc05hbWVxAH4AAUwAFW1fY29tcG9uZW50UHJvcGVydGllc3QAD0xqYXZhL3V0aWwvTWFwO0wAEG1faGllcmFyY2h5TmFtZXN0ABBMamF2YS91dGlsL0xpc3Q7TAAMbV9uZWlnaGJvdXJzcQB+AANMABRtX3N1cHBvcnRlZENsYXNzTmFtZXEAfgABeHAAv/AAAAAAAAD/////cHQAG2phdmFmeC5zY2VuZS5jaGFydC5QaWVDaGFydHBzcgATamF2YS51dGlsLkFycmF5TGlzdHiB0h2Zx2GdAwABSQAEc2l6ZXhwAAAABHcEAAAABHQAFGphdmFmeC5zdGFnZS5TdGFnZV8xdAAUamF2YWZ4LnNjZW5lLlNjZW5lXzF0ABpqYXZhZnguc2NlbmUubGF5b3V0LlZCb3hfMXQACHBpZUNoYXJ0eHNxAH4ABgAAAAF3BAAAAAF0ABpqYXZhZnguc2NlbmUubGF5b3V0LkhCb3hfMXhxAH4ABQ==");
    private static GraphicsComponent button;

    @BeforeClass
    public static void loadObjectMapping() throws Exception {
        ComponentIdentifier buttonCI = MakeR.createCI((String)"rO0ABXNyAD1vcmcuZWNsaXBzZS5qdWJ1bGEudG9vbHMuaW50ZXJuYWwub2JqZWN0cy5Db21wb25lbnRJZGVudGlmaWVyAAAAAAAABAcCAAlaABRtX2VxdWFsT3JpZ2luYWxGb3VuZEQAEW1fbWF0Y2hQZXJjZW50YWdlSQAhbV9udW1iZXJPZk90aGVyTWF0Y2hpbmdDb21wb25lbnRzTAAYbV9hbHRlcm5hdGl2ZURpc3BsYXlOYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7TAAUbV9jb21wb25lbnRDbGFzc05hbWVxAH4AAUwAFW1fY29tcG9uZW50UHJvcGVydGllc3QAD0xqYXZhL3V0aWwvTWFwO0wAEG1faGllcmFyY2h5TmFtZXN0ABBMamF2YS91dGlsL0xpc3Q7TAAMbV9uZWlnaGJvdXJzcQB+AANMABRtX3N1cHBvcnRlZENsYXNzTmFtZXEAfgABeHAAv/AAAAAAAAD/////cHQAG2phdmFmeC5zY2VuZS5jb250cm9sLkJ1dHRvbnBzcgATamF2YS51dGlsLkFycmF5TGlzdHiB0h2Zx2GdAwABSQAEc2l6ZXhwAAAABXcEAAAABXQAFGphdmFmeC5zdGFnZS5TdGFnZV8xdAAUamF2YWZ4LnNjZW5lLlNjZW5lXzF0ABpqYXZhZnguc2NlbmUubGF5b3V0LlZCb3hfMXQAGmphdmFmeC5zY2VuZS5sYXlvdXQuSEJveF8xdAAKcGx1c0J1dHRvbnhzcQB+AAYAAAABdwQAAAABdAALbWludXNCdXR0b254cQB+AAU=");
        button = JavafxComponents.createButton((ComponentIdentifier)buttonCI);
    }

    @Before
    public void setUp() throws Exception {
        this.m_agent = MakeR.createAUTAgent((String)AGENT_HOST, (int)60000);
        this.m_agent.connect();
        JavaFXAUTConfiguration config = new JavaFXAUTConfiguration("api.aut.conf.javafx.extension", "JavaFXExampleExtensionAUT", "..\\jre\\bin\\java.exe", "..\\examples\\", new String[]{"-jar", "development\\extension\\AUT\\PieChart.jar"});
        AUTIdentifier id = this.m_agent.startAUT((AUTConfiguration)config);
        if (id != null) {
            ToolkitInfo toolkitInformation = JavafxToolkit.createToolkitInformation();
            this.m_pcc = new PieChartComponents(toolkitInformation);
            this.m_aut = this.m_agent.getAUT(id, this.m_pcc.getToolkitInfo());
            this.m_aut.connect();
        } else {
            Assert.fail((String)"AUT start has failed!");
        }
    }

    @Test
    public void testPieChartSpecificAction() throws Exception {
        this.m_aut.execute(this.m_pcc.checkNumberOfItems(pieChartIdentifier, 5), (Object)"Verify initial number of slices");
        this.m_aut.execute(button.click(Integer.valueOf(1), ValueSets.InteractionMode.primary), (Object)"Increment number of pies");
        this.m_aut.execute(this.m_pcc.checkNumberOfItems(pieChartIdentifier, 6), (Object)"Verify incremented number of slices");
    }

    @Test(expected=CheckFailedException.class)
    public void testExpectedCheckFailed() throws Exception {
        this.m_aut.execute(this.m_pcc.checkNumberOfItems(pieChartIdentifier, 4), (Object)"Expected failure for initial number of slice verification");
    }

    @After
    public void tearDown() throws Exception {
        this.m_aut.disconnect();
        this.m_agent.stopAUT(this.m_aut.getIdentifier());
        this.m_agent.disconnect();
    }
}

