/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the TableComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-25T08:17:59.686Z")
@Beta
public interface TableComponentActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.TextInputComponentActionHandler {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * 
         */
        public void inputTextSpecifyCell(
            @Nullable String text,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * 
         */
        public void replaceTextSpecifyCell(
            @Nullable String text,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer numberOfClicks,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param direction 
         *        the direction
         * @param numberOfCells 
         *        the number of cells
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * 
         */
        public void move(
            @Nullable Direction direction,
            @Nullable Integer numberOfCells,
            @Nullable Integer numberOfClicks,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable BinaryChoice extendSelection
        ) ;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * 
         */
        public void checkEditabilitySpecifyCell(
            @Nullable Boolean editable,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * 
         */
        public void checkEditabilityOfSelectedCell(
            @Nullable Boolean editable
        ) ;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * 
         */
        public void checkEditabilityOfCellMousePosition(
            @Nullable Boolean editable
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * 
         */
        public void checkTextSpecifyCell(
            @Nullable String text,
            @Nullable Operator textOperator,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public void checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * 
         */
        public void checkExistenceOfValueInRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * 
         */
        public void checkExistenceOfValueInColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectValueFromColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectValueFromRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public void dragCell(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public void dropOnCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * 
         */
        public void dragCellFromColumn(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public void dropOnCellFromColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * 
         */
        public void dragCellFromRow(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public void dropOnCellFromRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param checked 
         *        Checked
         * 
         */
        public void checkSelectionOfCheckboxInSelectedRow(
            @Nullable Boolean checked
        ) ;
        
        /**
         * 
         * @param checked 
         *        Checked
         * 
         */
        public void checkSelectionOfCheckboxAtMousePosition(
            @Nullable Boolean checked
        ) ;
        
        public void toggleCheckboxInSelectedRow(
        ) ;
        
        public void toggleCheckboxAtMousePosition(
        ) ;
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @since 4.0
         */
        public void checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @since 4.0
         */
        public void checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists
        ) ;
        
} 