/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.ObjectMapping;
import org.eclipse.jubula.client.exceptions.LoadResourceException;
import org.eclipse.jubula.client.internal.utils.SerilizationUtils;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMappingImpl
implements ObjectMapping {
    private static Logger log = LoggerFactory.getLogger(ObjectMappingImpl.class);
    private Properties m_objectMappingAssociations = new Properties();
    private Map<String, ComponentIdentifier> m_map = new TreeMap<String, ComponentIdentifier>();

    public ObjectMappingImpl(InputStream input) {
        Validate.notNull((Object)input, (String)"The input stream must not be null.");
        try {
            this.m_objectMappingAssociations.load(input);
            for (Object obj : this.m_objectMappingAssociations.keySet()) {
                if (!(obj instanceof String)) continue;
                String compName = (String)obj;
                if (this.m_map.containsKey(compName)) {
                    log.error("There is already a mapping for the component name " + compName);
                    continue;
                }
                try {
                    String encodedString = this.m_objectMappingAssociations.getProperty(compName);
                    this.m_map.put(compName, ObjectMappingImpl.getIdentifier(encodedString));
                }
                catch (LoadResourceException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error("Error while initialising the ObjectMappingLoader", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public ComponentIdentifier get(@NonNull String compName) {
        Validate.notNull((Object)compName, (String)"The component name must not be null.");
        return this.m_map.get(compName);
    }

    public static <T> ComponentIdentifier<T> getIdentifier(String encodedString) throws LoadResourceException {
        try {
            if (encodedString != null) {
                Object decodedObject = SerilizationUtils.decode(encodedString);
                if (decodedObject instanceof ComponentIdentifier) {
                    return (ComponentIdentifier)decodedObject;
                }
                throw new LoadResourceException("The decoded object is not of type 'org.eclipse.jubula.tools.ComponentIdentifier<T>'.");
            }
        }
        catch (IOException e) {
            throw new LoadResourceException("Could load the given component name", e);
        }
        catch (ClassNotFoundException e) {
            throw new LoadResourceException("Problems during deserialization...", e);
        }
        return null;
    }
}

