/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.sourceprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.ui.rcp.businessprocess.StartAutBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.client.ui.utils.JobUtils;

public class AvailableAutSourceProvider
extends AbstractJBSourceProvider
implements DataEventDispatcher.IServerConnectionListener,
DataEventDispatcher.IProjectStateListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener {
    public static final String IS_AUT_AVAILABLE = "org.eclipse.jubula.client.ui.rcp.variable.isAutAvailable";

    public AvailableAutSourceProvider() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addAutAgentConnectionListener((DataEventDispatcher.IServerConnectionListener)this, true);
        ded.addProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
    }

    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeAutAgentConnectionListener((DataEventDispatcher.IServerConnectionListener)this);
        ded.removeProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
        ded.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(IS_AUT_AVAILABLE, this.isAutAvailable());
        return values;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_AUT_AVAILABLE};
    }

    public void handleServerConnStateChanged(DataEventDispatcher.ServerState state) {
        this.fireSourceChanged();
    }

    private void fireSourceChanged() {
        final String jobName = Messages.UIJobResolvingStartableAuts;
        Job resolveStartableAUTs = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                AvailableAutSourceProvider.this.gdFireSourceChanged(0, AvailableAutSourceProvider.IS_AUT_AVAILABLE, AvailableAutSourceProvider.this.isAutAvailable());
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        JobUtils.executeJob((Job)resolveStartableAUTs, null);
    }

    private boolean isAutAvailable() {
        return !StartAutBP.getInstance().getAllAUTs().isEmpty();
    }

    public void handleProjectLoaded() {
        this.fireSourceChanged();
    }

    public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
        if (DataEventDispatcher.ProjectState.prop_modified.equals((Object)state)) {
            this.fireSourceChanged();
        }
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (po instanceof IProjectPO && dataState == DataEventDispatcher.DataState.Deleted) {
            this.fireSourceChanged();
        }
    }
}

