/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.util.compatibility;

import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableColumnBase;
import org.eclipse.jubula.rc.javafx.tester.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.tester.util.NodeTraverseHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUtils {
    private static final String GET_COLUMN_HEADER_FOR = "getColumnHeaderFor";
    private static final String JAVA9_TABLE_HEADER_ROW = "javafx.scene.control.skin.TableHeaderRow";
    private static final String JAVA8_TABLE_HEADER_ROW = "com.sun.javafx.scene.control.skin.TableHeaderRow";
    private static Logger log = LoggerFactory.getLogger(TableUtils.class);

    private TableUtils() {
    }

    public static Rectangle getNodeBoundsofHeader(Parent table, TableColumnBase<?, ?> column, boolean relative) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(JAVA8_TABLE_HEADER_ROW);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(JAVA9_TABLE_HEADER_ROW);
            }
            catch (ClassNotFoundException e2) {
                String message = "neither com.sun.javafx.scene.control.skin.TableHeaderRow nor javafx.scene.control.skin.TableHeaderRow found";
                log.error(message, (Throwable)e2);
                throw new RuntimeException(message, e2);
            }
        }
        try {
            List<?> headerRow = NodeTraverseHelper.getInstancesOf(table, clazz);
            Object colH = null;
            for (Object tableHeaderRow : headerRow) {
                Method method = clazz.getMethod(GET_COLUMN_HEADER_FOR, TableColumnBase.class);
                colH = method.invoke(tableHeaderRow, column);
                if (colH == null) continue;
                if (relative) {
                    return NodeBounds.getRelativeBounds((Node)colH, (Node)tableHeaderRow);
                }
                return NodeBounds.getAbsoluteBounds((Node)colH);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error occured", (Throwable)e);
        }
        return null;
    }
}

