/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.autagent.commands.AbstractStartToolkitAut;
import org.eclipse.jubula.autagent.monitoring.IMonitoring;
import org.eclipse.jubula.autagent.monitoring.MonitoringDataStore;
import org.eclipse.jubula.autagent.monitoring.MonitoringUtil;
import org.eclipse.jubula.communication.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.jarutils.MainClassLocator;
import org.eclipse.osgi.service.datalocation.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartJavaAut
extends AbstractStartToolkitAut {
    protected static final String JAVA_OPTIONS_INTRO = "_JAVA_OPTIONS=";
    private static final String JAVA_LANGUAGE_PROPERTY = "-Duser.language=";
    private static final String JAVA_COUNTRY_PROPERTY = "-Duser.country=";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStartJavaAut.class);

    @Override
    protected String createBaseCmd(Map parameters) throws IOException {
        String executableFileName = (String)parameters.get("EXECUTABLE");
        if (executableFileName != null && executableFileName.length() > 0) {
            File exe = new File(executableFileName);
            if (!exe.isAbsolute()) {
                exe = new File((String)parameters.get("WORKING_DIR"), executableFileName);
            }
            if (exe.isFile() && exe.exists()) {
                return exe.getCanonicalPath();
            }
            String errorMsg = String.valueOf(executableFileName) + " does not point to a valid executable.";
            LOG.warn(errorMsg);
            return executableFileName;
        }
        String java = "";
        String jre = (String)parameters.get("JRE_BINARY");
        if (jre == null) {
            jre = "";
        }
        File jreFile = new File(jre);
        if (jre.length() == 0) {
            java = "java";
        } else {
            if (!jreFile.isAbsolute()) {
                jreFile = new File(this.getWorkingDir(parameters), jre);
            }
            if (jreFile.isFile() && jreFile.exists()) {
                java = jreFile.getCanonicalPath();
            } else {
                String errorMsg = jreFile + " does not point to a valid JRE executable.";
                LOG.error(errorMsg);
                throw new FileNotFoundException(errorMsg);
            }
        }
        return java;
    }

    protected String getAUTMainClass(Map parameters) {
        String autClassName = (String)parameters.get("CLASSNAME");
        if (autClassName != null && autClassName.length() > 0) {
            return autClassName;
        }
        String jarFile = (String)parameters.get("JAR_FILE");
        String mainClass = this.getMainClassFromManifest(parameters);
        if (mainClass != null) {
            return mainClass;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("neither main class transmitted nor found in the manifest, searching in jar: '" + String.valueOf(jarFile) + "'");
        }
        if (jarFile != null && jarFile.length() > 0) {
            List mains;
            block10: {
                block9: {
                    mains = MainClassLocator.getMainClass((File)new File(jarFile));
                    if (mains.size() != 0) break block9;
                    String message = "no main class found in '" + jarFile + "'";
                    LOG.error(message);
                    this.setErrorMessage(new StartAUTServerStateMessage(6, message));
                    return null;
                }
                if (mains.size() == 1) break block10;
                String message = "more than on main class found";
                LOG.error(message);
                this.setErrorMessage(new StartAUTServerStateMessage(7, message));
                return null;
            }
            try {
                return ((String)mains.get(0)).replace('/', '.');
            }
            catch (NullPointerException npe) {
                String message = "no jar given as classpath";
                LOG.error(message, (Throwable)npe);
                this.setErrorMessage(new StartAUTServerStateMessage(8, message));
                return null;
            }
            catch (IOException ioe) {
                String message = "scanning '" + String.valueOf(jarFile) + "' for main class failed";
                LOG.error(message, (Throwable)ioe);
                this.setErrorMessage(new StartAUTServerStateMessage(9, message));
                return null;
            }
        }
        return null;
    }

    private String getMainClassFromManifest(Map parameters) {
        String jarFile = this.createAbsoluteJarPath(parameters);
        return this.getAttributeFromManifest("main-class", jarFile);
    }

    private String getAttributeFromManifest(String attributeName, String jarFile) {
        if (jarFile == null || jarFile.length() < 1) {
            return null;
        }
        String attribute = null;
        try {
            JarFile jar = new JarFile(jarFile);
            Manifest manifest = jar.getManifest();
            if (manifest != null) {
                attribute = manifest.getMainAttributes().getValue(attributeName);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("File not found: " + jarFile, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error reading jar file: " + jarFile, (Throwable)e);
        }
        return attribute;
    }

    private String createAbsoluteJarPath(Map parameters) {
        File jarFile;
        File workingDir = this.getWorkingDir(parameters);
        String jarPath = (String)parameters.get("JAR_FILE");
        if (jarPath != null && jarPath.length() > 0 && workingDir != null && !(jarFile = new File(jarPath)).isAbsolute()) {
            jarPath = workingDir + FILE_SEPARATOR + jarPath;
        }
        return jarPath;
    }

    protected abstract String getServerClassName();

    protected void addLocale(List cmds, Locale locale) {
        if (locale != null) {
            if (locale.getCountry() != null && locale.getCountry().length() > 0) {
                cmds.add(JAVA_COUNTRY_PROPERTY + locale.getCountry());
            }
            if (locale.getLanguage() != null && locale.getLanguage().length() > 0) {
                cmds.add(JAVA_LANGUAGE_PROPERTY + locale.getLanguage());
            }
        }
    }

    protected String getClassPathFromManifest(Map parameters) {
        String jarFile = this.createAbsoluteJarPath(parameters);
        String classPath = this.getAttributeFromManifest("class-path", jarFile);
        if (classPath == null) {
            return "";
        }
        classPath = classPath.trim();
        return classPath.replace(' ', PATH_SEPARATOR.charAt(0));
    }

    protected String convertClientSeparator(String clientPath) {
        return clientPath.replaceAll(";", PATH_SEPARATOR);
    }

    @Override
    protected abstract String[] createCmdArray(String var1, Map var2);

    protected boolean isRunningFromExecutable(Map parameters) {
        return parameters.containsKey("EXECUTABLE");
    }

    protected boolean isRunningWithMonitoring(Map parameters) {
        String monitoringId = (String)parameters.get("MONITORING_AGENT_ID");
        return !StringUtils.isEmpty((String)monitoringId);
    }

    protected String setJavaOptions(Map parameters) {
        StringBuffer sb = new StringBuffer();
        if (this.isRunningFromExecutable(parameters)) {
            Locale locale = (Locale)parameters.get("LOCALE");
            sb.append(JAVA_OPTIONS_INTRO);
            if (this.isRunningWithMonitoring(parameters)) {
                sb.append(this.getMonitoringAgent(parameters)).append(" ");
            }
            sb.append("\"").append("-javaagent:").append(this.getAbsoluteAgentJarPath()).append("\"");
            if (locale != null) {
                sb.append(" ").append(JAVA_COUNTRY_PROPERTY).append(locale.getCountry());
                sb.append(" ").append(JAVA_LANGUAGE_PROPERTY).append(locale.getLanguage());
            }
        } else if (this.isRunningWithMonitoring(parameters)) {
            sb.append(JAVA_OPTIONS_INTRO).append(this.getMonitoringAgent(parameters));
        }
        return sb.toString();
    }

    protected String getAbsoluteAgentJarPath() {
        return AbstractStartToolkitAut.getClasspathForBundleId("org.eclipse.jubula.rc.common.agent");
    }

    private URL[] getExtensions() {
        URL[] urls;
        File extDir = AbstractStartJavaAut.getExtDir();
        File[] extJars = extDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (extJars != null) {
            LOG.info("jars are " + extJars);
            urls = new URL[extJars.length];
            int i = 0;
            while (i < extJars.length) {
                try {
                    urls[i] = extJars[i].toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOG.error("URL is malformed", (Throwable)e);
                }
                ++i;
            }
        } else {
            LOG.info("no ext jars");
            urls = new URL[]{};
        }
        return urls;
    }

    public static File getExtDir() {
        File installDir = AbstractStartJavaAut.getInstallDir();
        File extDir = new File(installDir, "./lib/ext/");
        return extDir;
    }

    public static File getInstallDir() {
        Location installLoc = Platform.getInstallLocation();
        String installDir = installLoc.getURL().getFile();
        return new File(installDir);
    }

    protected String getMonitoringAgent(Map parameters) {
        String monitoringAgentClass = (String)parameters.get("AGENT_CLASS");
        String autId = (String)parameters.get("AUT_ID");
        MonitoringDataStore mds = MonitoringDataStore.getInstance();
        boolean duplicate = MonitoringUtil.checkForDuplicateAutID(autId);
        if (!duplicate) {
            mds.putConfigMap(autId, parameters);
        }
        String agentString = null;
        if (this.isRunningWithMonitoring(parameters)) {
            try {
                URLClassLoader loader = new URLClassLoader(this.getExtensions(), this.getClass().getClassLoader());
                Class<?> monitoringClass = loader.loadClass(monitoringAgentClass);
                Constructor<?> constructor = monitoringClass.getConstructor(new Class[0]);
                IMonitoring agentInstance = (IMonitoring)constructor.newInstance(new Object[0]);
                agentInstance.setAutId(autId);
                agentInstance.setInstallDir(AbstractStartJavaAut.getInstallDir());
                agentString = agentInstance.createAgent();
                if (!duplicate) {
                    mds.putMonitoringAgent(autId, agentInstance);
                }
            }
            catch (ClassNotFoundException e) {
                String errorMsg = "The monitoring class could not be loaded via reflection ";
                LOG.error(errorMsg, (Throwable)e);
            }
            catch (InstantiationException e) {
                String errorMsg = "The instantiation of the monitoring class failed ";
                LOG.error(errorMsg, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                String errorMsg = "Access to the monitoring class failed ";
                LOG.error(errorMsg, (Throwable)e);
            }
            catch (SecurityException e) {
                String errorMsg = "Access to the monitoring class failed ";
                LOG.error(errorMsg, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                String errorMsg = "A method in the monitoring class could not be found";
                LOG.error(errorMsg, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                String errorMsg = "A argument which is passed to monitoring class is invalide";
                LOG.error(errorMsg, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                String errorMsg = "The method call of 'getAgent' failed, you have to implement the interface 'IMonitoring";
                LOG.error(errorMsg, (Throwable)e);
            }
        }
        return agentString;
    }
}

