/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.AbstractStartToolkitAut;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartHtmlAutServerCommand
extends AbstractStartToolkitAut {
    private static final String DEFAULT_AUT_ID_ATTRIBUTE_NAME = "id";
    private static final Map BROWSER_TO_CMD_MAP = new HashMap();
    private static final Logger LOG;

    static {
        BROWSER_TO_CMD_MAP.put("Firefox", "*firefox");
        BROWSER_TO_CMD_MAP.put("InternetExplorer", "*iexplore");
        BROWSER_TO_CMD_MAP.put("Safari", "*safari");
        LOG = LoggerFactory.getLogger(StartHtmlAutServerCommand.class);
    }

    @Override
    protected String createBaseCmd(Map parameters) throws IOException {
        String jre = String.valueOf(System.getProperty("java.home")) + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "java";
        if (EnvironmentUtils.isWindowsOS()) {
            jre = String.valueOf(jre) + ".exe";
        }
        if (jre != null && jre.length() > 0) {
            File exe = new File(jre);
            if (exe.isFile() && exe.exists()) {
                return exe.getCanonicalPath();
            }
            String errorMsg = String.valueOf(jre) + " does not point to a valid executable.";
            LOG.error(errorMsg);
            throw new FileNotFoundException(errorMsg);
        }
        return jre;
    }

    @Override
    protected String[] createCmdArray(String baseCmd, Map parameters) {
        String[] bundlesToAddToClasspath;
        Vector<String> commands = new Vector<String>();
        commands.add(baseCmd);
        if (BXDEBUG != null) {
            commands.add("-Xdebug");
            commands.add("-agentlib:jdwp=transport=dt_socket,address=" + BXDEBUG + ",server=y,suspend=y");
        }
        StringBuilder serverClasspath = new StringBuilder();
        String[] stringArray = bundlesToAddToClasspath = new String[]{"com.bredexsw.jubula.rc.html", "org.eclipse.jubula.tools", "org.eclipse.jubula.communication", "org.eclipse.jubula.rc.common", "org.slf4j.jcl", "org.slf4j.api", "ch.qos.logback.classic", "ch.qos.logback.core", "ch.qos.logback.slf4j", "org.apache.commons.lang", "org.apache.oro", "org.apache.commons.collections"};
        int n = bundlesToAddToClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId = stringArray[n2];
            serverClasspath.append(AbstractStartToolkitAut.getClasspathForBundleId(bundleId));
            serverClasspath.append(PATH_SEPARATOR);
            ++n2;
        }
        commands.add("-classpath");
        commands.add(serverClasspath.toString());
        commands.add("com.bredexsw.jubula.rc.html.WebAUTServer");
        commands.add(String.valueOf(AutStarter.getInstance().getAutCommunicator().getLocalPort()));
        commands.add(String.valueOf(parameters.get("AUT_ARGUMENTS")));
        commands.add(this.getBrowserString(parameters.get("BROWSER_PATH"), parameters.get("BROWSER")));
        commands.add("AUT");
        commands.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost")));
        commands.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort")));
        commands.add(String.valueOf(parameters.get("AUT_ID")));
        Object idAttribute = parameters.get("WEB_ID_TAG");
        if (idAttribute != null) {
            commands.add(String.valueOf(idAttribute));
        } else {
            commands.add(DEFAULT_AUT_ID_ATTRIBUTE_NAME);
        }
        return commands.toArray(new String[commands.size()]);
    }

    private String getBrowserString(Object browserPath, Object browserType) {
        Object browser = BROWSER_TO_CMD_MAP.get(browserType);
        if (browser == null) {
            throw new IllegalArgumentException("Unsupported browser type: " + browserType);
        }
        String browserString = String.valueOf(browser);
        if (browserPath != null) {
            browserString = String.valueOf(browserString) + " " + String.valueOf(browserPath);
        }
        return browserString;
    }
}

