/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.AbstractStartJavaAut;
import org.eclipse.jubula.autagent.commands.AbstractStartToolkitAut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartSwingAutServerCommand
extends AbstractStartJavaAut {
    private static final Logger LOG = LoggerFactory.getLogger(StartSwingAutServerCommand.class);
    private static final String ENV_SEPARATOR = "\n";
    private String m_autServerClasspath = "AutServerClasspath";

    @Override
    protected String[] createEnvArray(Map parameters, boolean isAgentSet) {
        if (this.isRunningFromExecutable(parameters) || this.isRunningWithMonitoring(parameters)) {
            this.setEnv(parameters);
            boolean agentActive = true;
            return super.createEnvArray(parameters, agentActive);
        }
        return super.createEnvArray(parameters, isAgentSet);
    }

    private void setEnv(Map parameters) {
        String env = (String)parameters.get("ENVIRONMENT");
        env = env == null ? "" : String.valueOf(env) + ENV_SEPARATOR;
        env = String.valueOf(env) + this.setJavaOptions(parameters);
        if (this.isRunningFromExecutable(parameters)) {
            String serverPort = "null";
            if (AutStarter.getInstance().getAutCommunicator() != null) {
                serverPort = String.valueOf(AutStarter.getInstance().getAutCommunicator().getLocalPort());
            }
            env = String.valueOf(env) + "\nAUT_SERVER_PORT=" + serverPort;
            env = String.valueOf(env) + "\nAUT_SERVER_CLASSPATH=" + this.m_autServerClasspath;
            env = String.valueOf(env) + "\nAUT_SERVER_NAME=" + this.getServerClassName();
            env = String.valueOf(env) + "\ncom.bredexsw.guidancer.aut.register.autAgentHost=" + parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost");
            env = String.valueOf(env) + "\ncom.bredexsw.guidancer.aut.register.autAgentPort=" + parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort");
            env = String.valueOf(env) + "\ncom.bredexsw.guidancer.aut.register.autName=" + parameters.get("com.bredexsw.guidancer.aut.register.autName");
        }
        parameters.put("ENVIRONMENT", env);
    }

    @Override
    protected String[] createCmdArray(String baseCmd, Map parameters) {
        Vector<String> cmds = new Vector<String>();
        cmds.add(baseCmd);
        StringBuffer autServerClasspath = new StringBuffer();
        this.createServerClasspath(autServerClasspath);
        ArrayList<String> autAgentArgs = new ArrayList<String>();
        autAgentArgs.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost")));
        autAgentArgs.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort")));
        autAgentArgs.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autName")));
        if (!this.isRunningFromExecutable(parameters)) {
            this.createAutServerLauncherClasspath(cmds, autServerClasspath, parameters);
            this.createAutServerClasspath(autServerClasspath, cmds, parameters);
            cmds.addAll(autAgentArgs);
            cmds.add("false");
        } else {
            String serverBasePath = this.createServerBasePath();
            autServerClasspath.append(PATH_SEPARATOR).append(serverBasePath).append(PATH_SEPARATOR).append(this.getRcBundleClassPath());
            this.m_autServerClasspath = autServerClasspath.toString();
        }
        cmds.addAll(this.createAutArguments(parameters));
        return cmds.toArray(new String[cmds.size()]);
    }

    public String[] getLaunchClasspath() {
        StringBuffer autServerClasspath = new StringBuffer();
        this.createServerClasspath(autServerClasspath);
        autServerClasspath.append(PATH_SEPARATOR).append(this.getRcBundleClassPath());
        return autServerClasspath.toString().split(PATH_SEPARATOR);
    }

    private void addBaseSettings(List cmds, Map parameters) {
        this.addLocale(cmds, (Locale)parameters.get("LOCALE"));
        String jreParams = (String)parameters.get("JRE_PARAMETER");
        if (jreParams != null && jreParams.length() > 0) {
            StringTokenizer tok = new StringTokenizer(jreParams, " ");
            while (tok.hasMoreTokens()) {
                cmds.add(tok.nextToken());
            }
        }
        this.addDebugParams(cmds);
    }

    private void createServerClasspath(StringBuffer serverClasspath) {
        String[] bundlesToAddToClasspath;
        String[] stringArray = bundlesToAddToClasspath = new String[]{"org.eclipse.jubula.tools", "org.eclipse.jubula.communication", "org.eclipse.jubula.rc.common", "org.slf4j.jcl", "org.slf4j.api", "org.apache.commons.lang", "org.apache.oro", "org.apache.commons.beanutils", "org.apache.commons.collections"};
        int n = bundlesToAddToClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId = stringArray[n2];
            serverClasspath.append(AbstractStartToolkitAut.getClasspathForBundleId(bundleId));
            serverClasspath.append(PATH_SEPARATOR);
            ++n2;
        }
        serverClasspath.append(this.getAbsExtImplClassesPath());
        if (LOG.isDebugEnabled()) {
            LOG.debug("serverClasspath" + serverClasspath);
        }
    }

    private void createAutServerLauncherClasspath(List cmds, StringBuffer autServerClasspath, Map parameters) {
        this.addBaseSettings(cmds, parameters);
        cmds.add("-classpath");
        StringBuffer autClassPath = this.createAutClasspath(parameters);
        String serverBasePath = this.createServerBasePath();
        cmds.add(autClassPath.append(PATH_SEPARATOR).append(serverBasePath).toString());
        cmds.add("org.eclipse.jubula.rc.common.AutServerLauncher");
        autServerClasspath.append(PATH_SEPARATOR).append(serverBasePath);
    }

    private StringBuffer createAutClasspath(Map parameters) {
        String manifestClassPath;
        String jarFile;
        StringBuffer autClassPath;
        String autClassPathStr = (String)parameters.get("CLASSPATH");
        if (autClassPathStr == null) {
            autClassPathStr = "";
        }
        if ((autClassPath = new StringBuffer(this.convertClientSeparator(autClassPathStr))).length() > 0) {
            autClassPath.append(PATH_SEPARATOR);
        }
        if ((jarFile = (String)parameters.get("JAR_FILE")) == null) {
            jarFile = "";
        }
        if ((manifestClassPath = this.getClassPathFromManifest(parameters)).length() > 0) {
            autClassPath.append(manifestClassPath).append(PATH_SEPARATOR);
        }
        autClassPath.append(jarFile);
        if (jarFile != null && jarFile.length() > 0) {
            autClassPath.append(PATH_SEPARATOR);
        }
        return autClassPath;
    }

    private String createServerBasePath() {
        return AbstractStartToolkitAut.getClasspathForBundleId("org.eclipse.jubula.rc.common");
    }

    private void createAutServerClasspath(StringBuffer autServerClasspath, List cmds, Map parameters) {
        if (AutStarter.getInstance().getAutCommunicator() != null) {
            cmds.add(String.valueOf(AutStarter.getInstance().getAutCommunicator().getLocalPort()));
        } else {
            cmds.add("null");
        }
        String autMain = this.getAUTMainClass(parameters);
        if (autMain == null) {
            return;
        }
        cmds.add(autMain);
        autServerClasspath.append(PATH_SEPARATOR).append(this.getRcBundleClassPath());
        cmds.add(autServerClasspath.toString());
        cmds.add(this.getServerClassName());
    }

    protected String getRcBundleClassPath() {
        return AbstractStartToolkitAut.getClasspathForBundleId(this.getRcBundleId());
    }

    protected String getRcBundleId() {
        return "org.eclipse.jubula.rc.swing";
    }

    private List createAutArguments(Map parameters) {
        Vector<String> argsList = new Vector<String>();
        if (parameters.get("AUT_RUN_AUT_ARGUMENTS") instanceof String[]) {
            String[] autArgs = (String[])parameters.get("AUT_RUN_AUT_ARGUMENTS");
            return Arrays.asList(autArgs);
        }
        String autArguments = (String)parameters.get("AUT_ARGUMENTS");
        if (autArguments == null) {
            autArguments = "";
        }
        StringTokenizer args = new StringTokenizer(autArguments, " ");
        while (args.hasMoreTokens()) {
            String arg = args.nextToken();
            argsList.add(arg);
        }
        return argsList;
    }

    private void addDebugParams(List cmds) {
        if (BXDEBUG != null) {
            cmds.add("-Xdebug");
            cmds.add("-Xnoagent");
            cmds.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + BXDEBUG);
            cmds.add("-Djava.compiler=NONE");
        }
    }

    private String getAbsExtImplClassesPath() {
        File implDir = new File("./lib/extImplClasses");
        StringBuffer paths = new StringBuffer(implDir.getAbsolutePath());
        File[] jars = implDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (jars != null) {
            int maxIdx = jars.length;
            int i = 0;
            while (i < maxIdx) {
                File f = jars[i];
                paths.append(PATH_SEPARATOR);
                paths.append(f.getAbsolutePath());
                ++i;
            }
        }
        return paths.toString();
    }

    @Override
    protected String getAbsoluteAgentJarPath() {
        return AbstractStartToolkitAut.getClasspathForBundleId("org.eclipse.jubula.rc.common.agent");
    }

    @Override
    protected String getServerClassName() {
        return "org.eclipse.jubula.rc.swing.SwingAUTServer";
    }
}

