/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.compcheck;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

public class CompletenessPropagator
implements DataEventDispatcher.ICompletenessCheckListener {
    private static CompletenessPropagator instance;

    private CompletenessPropagator() {
        DataEventDispatcher.getInstance().addCompletenessCheckListener(this);
    }

    public static CompletenessPropagator getInstance() {
        if (instance == null) {
            instance = new CompletenessPropagator();
        }
        return instance;
    }

    public void completenessCheckFinished() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        TreeTraverser traverser = new TreeTraverser(project, new CompletenessPropagationOperation());
        traverser.traverse(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompletenessPropagationOperation
    implements ITreeNodeOperation<INodePO> {
        public static final IProblem ERROR_IN_CHILD = ProblemFactory.createProblem((IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.TooltipErrorInChildren));
        public static final IProblem WARNING_IN_CHILD = ProblemFactory.createProblem((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.TooltipWarningInChildren));

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            node.removeProblem(ERROR_IN_CHILD);
            node.removeProblem(WARNING_IN_CHILD);
            return node.isActive();
        }

        @Override
        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            IProblem worstProblem = ProblemFactory.getWorstProblem(node.getProblems());
            if (worstProblem != null) {
                this.setParentProblem(parent, worstProblem.getSeverity());
            }
        }

        private void setParentProblem(INodePO node, int severity) {
            switch (severity) {
                case 4: {
                    node.addProblem(ERROR_IN_CHILD);
                    break;
                }
                case 2: {
                    node.addProblem(WARNING_IN_CHILD);
                    break;
                }
            }
        }
    }
}

