/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import java.util.List;
import org.eclipse.jubula.client.core.IAUTInfoListener;
import org.eclipse.jubula.client.core.MessageFactory;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.commands.AUTStartedCommand;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTStateMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.SendAUTListOfSupportedComponentsMessage;
import org.eclipse.jubula.communication.message.SendCompSystemI18nMessage;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessprocess.ProfileBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTStateCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(AUTStateCommand.class);
    private static final int TIMEOUT = 500000;
    private AUTStateMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (AUTStateMessage)message;
    }

    public Message execute() {
        AUTStartedCommand callback = new AUTStartedCommand(new MyAUTInfoListener());
        callback.setStateMessage(this.m_message);
        try {
            SendAUTListOfSupportedComponentsMessage message = MessageFactory.getSendAUTListOfSupportedComponentsMessage();
            CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
            List components = compSystem.getComponents(TestExecution.getInstance().getConnectedAut().getToolkit(), true);
            message.setComponents(components);
            message.setProfile(ProfileBuilder.getActiveProfile());
            AUTConnection.getInstance().request((Message)message, callback, 500000);
            SendCompSystemI18nMessage i18nMessage = new SendCompSystemI18nMessage();
            i18nMessage.setResourceBundles(CompSystemI18n.bundlesToString());
            try {
                AUTConnection.getInstance().send((Message)i18nMessage);
            }
            catch (CommunicationException ce) {
                log.error(Messages.CommunicationErrorSetResourceBundle, (Throwable)ce);
            }
        }
        catch (CommunicationException bce) {
            log.error(Messages.CommunicationErrorGetResourceBundle, (Throwable)bce);
        }
        return null;
    }

    public void timeout() {
        log.info(Messages.TimeoutExpired);
    }

    static class MyAUTInfoListener
    implements IAUTInfoListener {
        MyAUTInfoListener() {
        }

        public void error(int reason) {
            switch (reason) {
                case 1: {
                    log.error(Messages.TimeoutOccuredGettingCompAUT);
                    break;
                }
                case 2: {
                    log.error(Messages.CouldNotRequestComsFromAUT);
                    break;
                }
                default: {
                    log.error(String.valueOf(Messages.UnknownErrorGettingAllCompsAUT) + ":" + String.valueOf(reason));
                }
            }
        }
    }
}

