/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.ObjectMappedMessage;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMappedCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(ObjectMappedCommand.class);
    private ObjectMappedMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (ObjectMappedMessage)message;
    }

    public Message execute() {
        this.mapObject(this.m_message.getComponentIdentifier());
        return null;
    }

    private void mapObject(IComponentIdentifier componentIdentifier) {
        if (log.isInfoEnabled()) {
            try {
                String logMessage = String.valueOf(Messages.MappedObject) + " " + "'" + componentIdentifier.getComponentName() + "'" + " " + Messages.OfType + " " + "'" + componentIdentifier.getComponentClassName() + "'" + " " + Messages.InHierachy + ":" + " ";
                for (String element : componentIdentifier.getHierarchyNames()) {
                    logMessage = String.valueOf(logMessage) + element + ",";
                }
                log.info(logMessage);
            }
            catch (ClassCastException classCastException) {
                log.error(Messages.ComponentIdentifiersDoes);
            }
        }
        if (TestExecution.getInstance().getConnectedAut() != null) {
            ObjectMappingEventDispatcher.notifyObjectMappedObserver(componentIdentifier);
        }
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + Messages.TimeoutCalled);
    }
}

